/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.failover.flip1;

import java.util.HashSet;
import org.apache.flink.runtime.executiongraph.failover.flip1.FailureHandlingResult;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Test;

public class FailureHandlingResultTest
extends TestLogger {
    @Test
    public void testNormalFailureHandlingResult() {
        ExecutionVertexID executionVertexID = new ExecutionVertexID(new JobVertexID(), 0);
        HashSet<ExecutionVertexID> tasks = new HashSet<ExecutionVertexID>();
        tasks.add(executionVertexID);
        long delay = 1234L;
        RuntimeException error = new RuntimeException();
        long timestamp = System.currentTimeMillis();
        FailureHandlingResult result = FailureHandlingResult.restartable((ExecutionVertexID)executionVertexID, (Throwable)error, (long)timestamp, tasks, (long)delay, (boolean)false);
        Assert.assertTrue((boolean)result.canRestart());
        Assert.assertEquals((long)delay, (long)result.getRestartDelayMS());
        Assert.assertEquals(tasks, (Object)result.getVerticesToRestart());
        Assert.assertThat((Object)result.getError(), (Matcher)IsSame.sameInstance((Object)error));
        Assert.assertThat((Object)result.getTimestamp(), (Matcher)CoreMatchers.is((Object)timestamp));
        Assert.assertTrue((boolean)result.getExecutionVertexIdOfFailedTask().isPresent());
        Assert.assertThat(result.getExecutionVertexIdOfFailedTask().get(), (Matcher)CoreMatchers.is((Object)executionVertexID));
    }

    @Test
    public void testRestartingSuppressedFailureHandlingResultWithNoCausingExecutionVertexId() {
        Exception error = new Exception("test error");
        long timestamp = System.currentTimeMillis();
        FailureHandlingResult result = FailureHandlingResult.unrecoverable(null, (Throwable)error, (long)timestamp, (boolean)false);
        Assert.assertFalse((boolean)result.canRestart());
        Assert.assertThat((Object)result.getError(), (Matcher)IsSame.sameInstance((Object)error));
        Assert.assertThat((Object)result.getTimestamp(), (Matcher)CoreMatchers.is((Object)timestamp));
        Assert.assertFalse((boolean)result.getExecutionVertexIdOfFailedTask().isPresent());
        try {
            result.getVerticesToRestart();
            Assert.fail((String)"get tasks to restart is not allowed when restarting is suppressed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            result.getRestartDelayMS();
            Assert.fail((String)"get restart delay is not allowed when restarting is suppressed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

