/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilderTestUtils;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.runtime.io.network.buffer.FreeingBufferRecycler;
import org.apache.flink.runtime.io.network.partition.BufferReaderWriterUtil;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class BufferReaderWriterUtilTest {
    @ClassRule
    public static final TemporaryFolder TMP_FOLDER = new TemporaryFolder();

    @Test
    public void writeReadByteBuffer() {
        ByteBuffer memory = ByteBuffer.allocateDirect(1200);
        Buffer buffer = BufferReaderWriterUtilTest.createTestBuffer();
        BufferReaderWriterUtil.writeBuffer((Buffer)buffer, (ByteBuffer)memory);
        int pos = memory.position();
        memory.flip();
        Buffer result = BufferReaderWriterUtil.sliceNextBuffer((ByteBuffer)memory);
        Assert.assertEquals((long)pos, (long)memory.position());
        BufferReaderWriterUtilTest.validateTestBuffer(result);
    }

    @Test
    public void writeByteBufferNotEnoughSpace() {
        ByteBuffer memory = ByteBuffer.allocateDirect(10);
        Buffer buffer = BufferReaderWriterUtilTest.createTestBuffer();
        boolean written = BufferReaderWriterUtil.writeBuffer((Buffer)buffer, (ByteBuffer)memory);
        Assert.assertFalse((boolean)written);
        Assert.assertEquals((long)0L, (long)memory.position());
        Assert.assertEquals((long)memory.capacity(), (long)memory.limit());
    }

    @Test
    public void readFromEmptyByteBuffer() {
        ByteBuffer memory = ByteBuffer.allocateDirect(100);
        memory.position(memory.limit());
        Buffer result = BufferReaderWriterUtil.sliceNextBuffer((ByteBuffer)memory);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testReadFromByteBufferNotEnoughData() {
        ByteBuffer memory = ByteBuffer.allocateDirect(1200);
        Buffer buffer = BufferReaderWriterUtilTest.createTestBuffer();
        BufferReaderWriterUtil.writeBuffer((Buffer)buffer, (ByteBuffer)memory);
        memory.flip().limit(memory.limit() - 1);
        ByteBuffer tooSmall = memory.slice();
        try {
            BufferReaderWriterUtil.sliceNextBuffer((ByteBuffer)tooSmall);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void writeReadFileChannel() throws Exception {
        FileChannel fc = BufferReaderWriterUtilTest.tmpFileChannel();
        Buffer buffer = BufferReaderWriterUtilTest.createTestBuffer();
        MemorySegment readBuffer = MemorySegmentFactory.allocateUnpooledOffHeapMemory((int)buffer.getSize(), null);
        BufferReaderWriterUtil.writeToByteChannel((FileChannel)fc, (Buffer)buffer, (ByteBuffer[])BufferReaderWriterUtil.allocatedWriteBufferArray());
        fc.position(0L);
        Buffer result = BufferReaderWriterUtil.readFromByteChannel((FileChannel)fc, (ByteBuffer)BufferReaderWriterUtil.allocatedHeaderBuffer(), (MemorySegment)readBuffer, (BufferRecycler)FreeingBufferRecycler.INSTANCE);
        BufferReaderWriterUtilTest.validateTestBuffer(result);
    }

    @Test
    public void readPrematureEndOfFile1() throws Exception {
        FileChannel fc = BufferReaderWriterUtilTest.tmpFileChannel();
        Buffer buffer = BufferReaderWriterUtilTest.createTestBuffer();
        MemorySegment readBuffer = MemorySegmentFactory.allocateUnpooledOffHeapMemory((int)buffer.getSize(), null);
        BufferReaderWriterUtil.writeToByteChannel((FileChannel)fc, (Buffer)buffer, (ByteBuffer[])BufferReaderWriterUtil.allocatedWriteBufferArray());
        fc.truncate(fc.position() - 1L);
        fc.position(0L);
        try {
            BufferReaderWriterUtil.readFromByteChannel((FileChannel)fc, (ByteBuffer)BufferReaderWriterUtil.allocatedHeaderBuffer(), (MemorySegment)readBuffer, (BufferRecycler)FreeingBufferRecycler.INSTANCE);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void readPrematureEndOfFile2() throws Exception {
        FileChannel fc = BufferReaderWriterUtilTest.tmpFileChannel();
        Buffer buffer = BufferReaderWriterUtilTest.createTestBuffer();
        MemorySegment readBuffer = MemorySegmentFactory.allocateUnpooledOffHeapMemory((int)buffer.getSize(), null);
        BufferReaderWriterUtil.writeToByteChannel((FileChannel)fc, (Buffer)buffer, (ByteBuffer[])BufferReaderWriterUtil.allocatedWriteBufferArray());
        fc.truncate(2L);
        fc.position(0L);
        try {
            BufferReaderWriterUtil.readFromByteChannel((FileChannel)fc, (ByteBuffer)BufferReaderWriterUtil.allocatedHeaderBuffer(), (MemorySegment)readBuffer, (BufferRecycler)FreeingBufferRecycler.INSTANCE);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testBulkWritingLargeNumberOfBuffers() throws Exception {
        int bufferSize = 1024;
        int numBuffers = 1025;
        try (FileChannel fileChannel = BufferReaderWriterUtilTest.tmpFileChannel();){
            ByteBuffer[] data = new ByteBuffer[numBuffers];
            for (int i = 0; i < numBuffers; ++i) {
                data[i] = ByteBuffer.allocateDirect(bufferSize);
            }
            int bytesExpected = bufferSize * numBuffers;
            BufferReaderWriterUtil.writeBuffers((FileChannel)fileChannel, (long)bytesExpected, (ByteBuffer[])data);
            Assert.assertEquals((long)bytesExpected, (long)fileChannel.size());
        }
    }

    @Test
    public void writeFileReadMemoryBuffer() throws Exception {
        FileChannel fc = BufferReaderWriterUtilTest.tmpFileChannel();
        Buffer buffer = BufferReaderWriterUtilTest.createTestBuffer();
        BufferReaderWriterUtil.writeToByteChannel((FileChannel)fc, (Buffer)buffer, (ByteBuffer[])BufferReaderWriterUtil.allocatedWriteBufferArray());
        ByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.position()).order(ByteOrder.nativeOrder());
        BufferReaderWriterUtil.configureByteBuffer((ByteBuffer)bb);
        fc.close();
        Buffer result = BufferReaderWriterUtil.sliceNextBuffer((ByteBuffer)bb);
        BufferReaderWriterUtilTest.validateTestBuffer(result);
    }

    private static FileChannel tmpFileChannel() throws IOException {
        return FileChannel.open(TMP_FOLDER.newFile().toPath(), StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
    }

    private static Buffer createTestBuffer() {
        return BufferBuilderTestUtils.buildBufferWithAscendingInts(1024, 200, 0);
    }

    private static void validateTestBuffer(Buffer buffer) {
        BufferBuilderTestUtils.validateBufferWithAscendingInts(buffer, 200, 0);
    }
}

