/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.nio.ByteBuffer;
import org.apache.flink.configuration.AkkaOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.NettyShuffleEnvironmentOptions;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriter;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.io.network.api.writer.ResultPartitionWriter;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.io.network.partition.consumer.BufferOrEvent;
import org.apache.flink.runtime.io.network.partition.consumer.IndexedInputGate;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobGraphTestUtils;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroup;
import org.apache.flink.runtime.testutils.MiniClusterResource;
import org.apache.flink.runtime.testutils.MiniClusterResourceConfiguration;
import org.apache.flink.runtime.testutils.TestingUtils;
import org.apache.flink.util.TestLogger;
import org.junit.ClassRule;
import org.junit.Test;

public class PartialConsumePipelinedResultTest
extends TestLogger {
    private static final int NUMBER_OF_TMS = 1;
    private static final int NUMBER_OF_SLOTS_PER_TM = 1;
    private static final int PARALLELISM = 1;
    private static final int NUMBER_OF_NETWORK_BUFFERS = 128;
    @ClassRule
    public static final MiniClusterResource MINI_CLUSTER_RESOURCE = new MiniClusterResource(new MiniClusterResourceConfiguration.Builder().setConfiguration(PartialConsumePipelinedResultTest.getFlinkConfiguration()).setNumberTaskManagers(1).setNumberSlotsPerTaskManager(1).build());

    private static Configuration getFlinkConfiguration() {
        Configuration config = new Configuration();
        config.set(AkkaOptions.ASK_TIMEOUT_DURATION, (Object)TestingUtils.DEFAULT_AKKA_ASK_TIMEOUT);
        config.setInteger(NettyShuffleEnvironmentOptions.NETWORK_NUM_BUFFERS, 128);
        return config;
    }

    @Test
    public void testPartialConsumePipelinedResultReceiver() throws Exception {
        JobVertex sender = new JobVertex("Sender");
        sender.setInvokableClass(SlowBufferSender.class);
        sender.setParallelism(1);
        JobVertex receiver = new JobVertex("Receiver");
        receiver.setInvokableClass(SingleBufferReceiver.class);
        receiver.setParallelism(1);
        receiver.connectNewDataSetAsInput(sender, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
        JobGraph jobGraph = JobGraphTestUtils.streamingJobGraph(sender, receiver);
        SlotSharingGroup slotSharingGroup = new SlotSharingGroup();
        sender.setSlotSharingGroup(slotSharingGroup);
        receiver.setSlotSharingGroup(slotSharingGroup);
        MINI_CLUSTER_RESOURCE.getMiniCluster().executeJobBlocking(jobGraph);
    }

    public static class SingleBufferReceiver
    extends AbstractInvokable {
        public SingleBufferReceiver(Environment environment) {
            super(environment);
        }

        public void invoke() throws Exception {
            IndexedInputGate gate = this.getEnvironment().getInputGate(0);
            gate.finishReadRecoveredState();
            while (!gate.getStateConsumedFuture().isDone()) {
                gate.pollNext();
            }
            gate.setChannelStateWriter(ChannelStateWriter.NO_OP);
            gate.requestPartitions();
            Buffer buffer = ((BufferOrEvent)gate.getNext().orElseThrow(IllegalStateException::new)).getBuffer();
            if (buffer != null) {
                buffer.recycleBuffer();
            }
        }
    }

    public static class SlowBufferSender
    extends AbstractInvokable {
        public SlowBufferSender(Environment environment) {
            super(environment);
        }

        public void invoke() throws Exception {
            ResultPartitionWriter writer = this.getEnvironment().getWriter(0);
            for (int i = 0; i < 8; ++i) {
                writer.emitRecord(ByteBuffer.allocate(1024), 0);
                Thread.sleep(50L);
            }
        }
    }
}

