/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.runtime.jobmanager.HighAvailabilityMode;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class HighAvailabilityModeTest
extends TestLogger {
    private static final HighAvailabilityMode DEFAULT_HA_MODE = HighAvailabilityMode.valueOf((String)"none".toUpperCase());

    @Test
    public void testFromConfig() throws Exception {
        Configuration config = new Configuration();
        Assert.assertEquals((Object)DEFAULT_HA_MODE, (Object)HighAvailabilityMode.fromConfig((Configuration)config));
        config.setString(HighAvailabilityOptions.HA_MODE, HighAvailabilityMode.ZOOKEEPER.name().toLowerCase());
        Assert.assertEquals((Object)HighAvailabilityMode.ZOOKEEPER, (Object)HighAvailabilityMode.fromConfig((Configuration)config));
        config.setString(HighAvailabilityOptions.HA_MODE, "factory.class.FQN");
        Assert.assertEquals((Object)HighAvailabilityMode.FACTORY_CLASS, (Object)HighAvailabilityMode.fromConfig((Configuration)config));
    }

    @Test
    public void testDeprecatedFromConfig() throws Exception {
        Configuration config = new Configuration();
        config.setString("recovery.mode", "standalone");
        Assert.assertEquals((Object)DEFAULT_HA_MODE, (Object)HighAvailabilityMode.fromConfig((Configuration)config));
        config.setString("recovery.mode", HighAvailabilityMode.ZOOKEEPER.name().toLowerCase());
        Assert.assertEquals((Object)HighAvailabilityMode.ZOOKEEPER, (Object)HighAvailabilityMode.fromConfig((Configuration)config));
        config.setString("high-availability", HighAvailabilityMode.NONE.name().toLowerCase());
        config.setString("recovery.mode", HighAvailabilityMode.ZOOKEEPER.name().toLowerCase());
        Assert.assertEquals((Object)HighAvailabilityMode.NONE, (Object)HighAvailabilityMode.fromConfig((Configuration)config));
    }

    @Test
    public void testCheckHighAvailabilityModeActivated() throws Exception {
        Configuration config = new Configuration();
        Assert.assertTrue((!HighAvailabilityMode.isHighAvailabilityModeActivated((Configuration)config) ? 1 : 0) != 0);
        config.setString("high-availability", HighAvailabilityMode.NONE.name().toLowerCase());
        Assert.assertTrue((!HighAvailabilityMode.isHighAvailabilityModeActivated((Configuration)config) ? 1 : 0) != 0);
        config.setString("high-availability", HighAvailabilityMode.ZOOKEEPER.name().toLowerCase());
        Assert.assertTrue((boolean)HighAvailabilityMode.isHighAvailabilityModeActivated((Configuration)config));
        config.setString("high-availability", HighAvailabilityMode.FACTORY_CLASS.name().toLowerCase());
        Assert.assertTrue((boolean)HighAvailabilityMode.isHighAvailabilityModeActivated((Configuration)config));
    }
}

