/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.core.testutils.OneShotLatch;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.jobmaster.JobManagerRunner;
import org.apache.flink.runtime.jobmaster.JobManagerRunnerResult;
import org.apache.flink.runtime.jobmaster.JobMasterGateway;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.messages.webmonitor.JobDetails;
import org.apache.flink.runtime.scheduler.ExecutionGraphInfo;
import org.apache.flink.util.Preconditions;

public class TestingJobManagerRunner
implements JobManagerRunner {
    private final JobID jobId;
    private final boolean blockingTermination;
    private final CompletableFuture<Void> terminationFuture;
    private final CompletableFuture<JobMasterGateway> jobMasterGatewayFuture;
    private final CompletableFuture<JobManagerRunnerResult> resultFuture;
    private final Supplier<JobDetails> jobDetailsFunction;
    private final OneShotLatch closeAsyncCalledLatch = new OneShotLatch();
    private JobStatus jobStatus = JobStatus.INITIALIZING;

    public static Builder newBuilder() {
        return new Builder();
    }

    private TestingJobManagerRunner(JobID jobId, boolean blockingTermination, CompletableFuture<JobMasterGateway> jobMasterGatewayFuture, CompletableFuture<JobManagerRunnerResult> resultFuture, Supplier<JobDetails> jobDetailsFunction) {
        this.jobId = jobId;
        this.blockingTermination = blockingTermination;
        this.jobMasterGatewayFuture = jobMasterGatewayFuture;
        this.resultFuture = resultFuture;
        this.jobDetailsFunction = jobDetailsFunction;
        this.terminationFuture = new CompletableFuture();
        ExecutionGraphInfo suspendedExecutionGraphInfo = new ExecutionGraphInfo(ArchivedExecutionGraph.createFromInitializingJob((JobID)jobId, (String)"TestJob", (JobStatus)JobStatus.SUSPENDED, null, null, (long)0L), null);
        this.terminationFuture.whenComplete((ignored, ignoredThrowable) -> resultFuture.complete(JobManagerRunnerResult.forSuccess((ExecutionGraphInfo)suspendedExecutionGraphInfo)));
    }

    public void start() throws Exception {
    }

    public CompletableFuture<JobMasterGateway> getJobMasterGateway() {
        return this.jobMasterGatewayFuture;
    }

    public CompletableFuture<JobManagerRunnerResult> getResultFuture() {
        return this.resultFuture;
    }

    public JobID getJobID() {
        return this.jobId;
    }

    public CompletableFuture<Acknowledge> cancel(Time timeout) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<JobStatus> requestJobStatus(Time timeout) {
        return CompletableFuture.completedFuture(this.jobStatus);
    }

    public CompletableFuture<JobDetails> requestJobDetails(Time timeout) {
        return CompletableFuture.completedFuture(this.jobDetailsFunction.get());
    }

    public CompletableFuture<ExecutionGraphInfo> requestJob(Time timeout) {
        throw new UnsupportedOperationException();
    }

    public boolean isInitialized() {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Void> closeAsync() {
        if (!this.blockingTermination) {
            this.terminationFuture.complete(null);
        }
        this.closeAsyncCalledLatch.trigger();
        return this.terminationFuture;
    }

    public void setJobStatus(JobStatus newStatus) {
        this.jobStatus = newStatus;
    }

    public OneShotLatch getCloseAsyncCalledLatch() {
        return this.closeAsyncCalledLatch;
    }

    public void completeResultFuture(ExecutionGraphInfo executionGraphInfo) {
        this.resultFuture.complete(JobManagerRunnerResult.forSuccess((ExecutionGraphInfo)executionGraphInfo));
    }

    public void completeResultFuture(JobManagerRunnerResult jobManagerRunnerResult) {
        this.resultFuture.complete(jobManagerRunnerResult);
    }

    public void completeResultFutureExceptionally(Exception e) {
        this.resultFuture.completeExceptionally(e);
    }

    public void completeTerminationFuture() {
        this.terminationFuture.complete(null);
    }

    public CompletableFuture<Void> getTerminationFuture() {
        return this.terminationFuture;
    }

    public void completeJobMasterGatewayFuture(JobMasterGateway testingJobMasterGateway) {
        this.jobMasterGatewayFuture.complete(testingJobMasterGateway);
    }

    public static class Builder {
        private JobID jobId = null;
        private boolean blockingTermination = false;
        private CompletableFuture<JobMasterGateway> jobMasterGatewayFuture = new CompletableFuture();
        private CompletableFuture<JobManagerRunnerResult> resultFuture = new CompletableFuture();
        private Supplier<JobDetails> jobDetailsFunction = () -> {
            throw new UnsupportedOperationException();
        };

        private Builder() {
        }

        public Builder setJobId(JobID jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder setBlockingTermination(boolean blockingTermination) {
            this.blockingTermination = blockingTermination;
            return this;
        }

        public Builder setJobMasterGatewayFuture(CompletableFuture<JobMasterGateway> jobMasterGatewayFuture) {
            Preconditions.checkNotNull(jobMasterGatewayFuture);
            this.jobMasterGatewayFuture = jobMasterGatewayFuture;
            return this;
        }

        public Builder setResultFuture(CompletableFuture<JobManagerRunnerResult> resultFuture) {
            Preconditions.checkNotNull(resultFuture);
            this.resultFuture = resultFuture;
            return this;
        }

        public Builder setJobDetailsFunction(Supplier<JobDetails> jobDetailsFunction) {
            this.jobDetailsFunction = (Supplier)Preconditions.checkNotNull(jobDetailsFunction);
            return this;
        }

        public TestingJobManagerRunner build() {
            Preconditions.checkNotNull((Object)this.jobId);
            return new TestingJobManagerRunner(this.jobId, this.blockingTermination, this.jobMasterGatewayFuture, this.resultFuture, this.jobDetailsFunction);
        }
    }
}

