/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.dump;

import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.metrics.dump.MetricDumpSerialization;
import org.apache.flink.runtime.webmonitor.retriever.MetricQueryServiceGateway;

public class TestingMetricQueryServiceGateway
implements MetricQueryServiceGateway {
    @Nonnull
    private final Supplier<CompletableFuture<MetricDumpSerialization.MetricSerializationResult>> queryMetricsSupplier;
    @Nonnull
    private final String address;

    public TestingMetricQueryServiceGateway(@Nonnull Supplier<CompletableFuture<MetricDumpSerialization.MetricSerializationResult>> queryMetricsSupplier, @Nonnull String address) {
        this.queryMetricsSupplier = queryMetricsSupplier;
        this.address = address;
    }

    public CompletableFuture<MetricDumpSerialization.MetricSerializationResult> queryMetrics(Time timeout) {
        return this.queryMetricsSupplier.get();
    }

    public String getAddress() {
        return this.address;
    }

    public String getHostname() {
        return "localhost";
    }

    public static class Builder {
        private Supplier<CompletableFuture<MetricDumpSerialization.MetricSerializationResult>> queryMetricsSupplier = CompletableFuture::new;
        private String address = "localhost";

        public Builder setQueryMetricsSupplier(Supplier<CompletableFuture<MetricDumpSerialization.MetricSerializationResult>> queryMetricsSupplier) {
            this.queryMetricsSupplier = queryMetricsSupplier;
            return this;
        }

        public Builder setAddress(String address) {
            this.address = address;
            return this;
        }

        public TestingMetricQueryServiceGateway build() {
            return new TestingMetricQueryServiceGateway(this.queryMetricsSupplier, this.address);
        }
    }
}

