/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.testutils;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.TaskInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.accumulators.AccumulatorRegistry;
import org.apache.flink.runtime.broadcast.BroadcastVariableManager;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.CheckpointMetrics;
import org.apache.flink.runtime.checkpoint.TaskStateSnapshot;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.externalresource.ExternalResourceInfoProvider;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.network.TaskEventDispatcher;
import org.apache.flink.runtime.io.network.api.writer.ResultPartitionWriter;
import org.apache.flink.runtime.io.network.partition.consumer.IndexedInputGate;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.tasks.InputSplitProvider;
import org.apache.flink.runtime.jobgraph.tasks.TaskOperatorEventGateway;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.metrics.groups.TaskMetricGroup;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.apache.flink.runtime.query.KvStateRegistry;
import org.apache.flink.runtime.query.TaskKvStateRegistry;
import org.apache.flink.runtime.state.TaskStateManager;
import org.apache.flink.runtime.state.TestTaskStateManager;
import org.apache.flink.runtime.taskexecutor.GlobalAggregateManager;
import org.apache.flink.runtime.taskexecutor.TestGlobalAggregateManager;
import org.apache.flink.runtime.taskmanager.NoOpTaskOperatorEventGateway;
import org.apache.flink.runtime.taskmanager.TaskManagerRuntimeInfo;
import org.apache.flink.runtime.throughput.ThroughputCalculator;
import org.apache.flink.runtime.util.TestingTaskManagerRuntimeInfo;
import org.apache.flink.runtime.util.TestingUserCodeClassLoader;
import org.apache.flink.util.UserCodeClassLoader;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.SystemClock;

public class DummyEnvironment
implements Environment {
    private final JobID jobId = new JobID();
    private final JobVertexID jobVertexId = new JobVertexID();
    private final ExecutionAttemptID executionId = new ExecutionAttemptID();
    private final ExecutionConfig executionConfig = new ExecutionConfig();
    private final TaskInfo taskInfo;
    private KvStateRegistry kvStateRegistry = new KvStateRegistry();
    private TaskStateManager taskStateManager;
    private final GlobalAggregateManager aggregateManager;
    private final AccumulatorRegistry accumulatorRegistry = new AccumulatorRegistry(this.jobId, this.executionId);
    private UserCodeClassLoader userClassLoader;

    public DummyEnvironment() {
        this("Test Job", 1, 0, 1);
    }

    public DummyEnvironment(ClassLoader userClassLoader) {
        this("Test Job", 1, 0, 1);
        this.userClassLoader = TestingUserCodeClassLoader.newBuilder().setClassLoader(userClassLoader).build();
    }

    public DummyEnvironment(String taskName, int numSubTasks, int subTaskIndex) {
        this(taskName, numSubTasks, subTaskIndex, numSubTasks);
    }

    public DummyEnvironment(String taskName, int numSubTasks, int subTaskIndex, int maxParallelism) {
        this.taskInfo = new TaskInfo(taskName, maxParallelism, subTaskIndex, numSubTasks, 0);
        this.taskStateManager = new TestTaskStateManager();
        this.aggregateManager = new TestGlobalAggregateManager();
    }

    public void setKvStateRegistry(KvStateRegistry kvStateRegistry) {
        this.kvStateRegistry = kvStateRegistry;
    }

    public KvStateRegistry getKvStateRegistry() {
        return this.kvStateRegistry;
    }

    public ExecutionConfig getExecutionConfig() {
        return this.executionConfig;
    }

    public JobID getJobID() {
        return this.jobId;
    }

    public JobVertexID getJobVertexId() {
        return this.jobVertexId;
    }

    public ExecutionAttemptID getExecutionId() {
        return this.executionId;
    }

    public Configuration getTaskConfiguration() {
        return new Configuration();
    }

    public TaskManagerRuntimeInfo getTaskManagerInfo() {
        return new TestingTaskManagerRuntimeInfo();
    }

    public TaskMetricGroup getMetricGroup() {
        return UnregisteredMetricGroups.createUnregisteredTaskMetricGroup();
    }

    public Configuration getJobConfiguration() {
        return new Configuration();
    }

    public TaskInfo getTaskInfo() {
        return this.taskInfo;
    }

    public InputSplitProvider getInputSplitProvider() {
        return null;
    }

    public IOManager getIOManager() {
        return null;
    }

    public MemoryManager getMemoryManager() {
        return null;
    }

    public UserCodeClassLoader getUserCodeClassLoader() {
        if (this.userClassLoader == null) {
            return TestingUserCodeClassLoader.newBuilder().build();
        }
        return this.userClassLoader;
    }

    public Map<String, Future<Path>> getDistributedCacheEntries() {
        return Collections.emptyMap();
    }

    public BroadcastVariableManager getBroadcastVariableManager() {
        return null;
    }

    public TaskStateManager getTaskStateManager() {
        return this.taskStateManager;
    }

    public GlobalAggregateManager getGlobalAggregateManager() {
        return this.aggregateManager;
    }

    public AccumulatorRegistry getAccumulatorRegistry() {
        return this.accumulatorRegistry;
    }

    public TaskKvStateRegistry getTaskKvStateRegistry() {
        return this.kvStateRegistry.createTaskRegistry(this.jobId, this.jobVertexId);
    }

    public void acknowledgeCheckpoint(long checkpointId, CheckpointMetrics checkpointMetrics) {
    }

    public ExternalResourceInfoProvider getExternalResourceInfoProvider() {
        return ExternalResourceInfoProvider.NO_EXTERNAL_RESOURCES;
    }

    public void acknowledgeCheckpoint(long checkpointId, CheckpointMetrics checkpointMetrics, TaskStateSnapshot subtaskState) {
    }

    public void declineCheckpoint(long checkpointId, CheckpointException cause) {
        throw new UnsupportedOperationException();
    }

    public void failExternally(Throwable cause) {
        throw new UnsupportedOperationException("DummyEnvironment does not support external task failure.");
    }

    public ResultPartitionWriter getWriter(int index) {
        return null;
    }

    public ResultPartitionWriter[] getAllWriters() {
        return new ResultPartitionWriter[0];
    }

    public IndexedInputGate getInputGate(int index) {
        throw new ArrayIndexOutOfBoundsException(0);
    }

    public IndexedInputGate[] getAllInputGates() {
        return new IndexedInputGate[0];
    }

    public TaskEventDispatcher getTaskEventDispatcher() {
        throw new UnsupportedOperationException();
    }

    public ThroughputCalculator getThroughputCalculator() {
        return new ThroughputCalculator((Clock)SystemClock.getInstance(), 10);
    }

    public void setTaskStateManager(TaskStateManager taskStateManager) {
        this.taskStateManager = taskStateManager;
    }

    public TaskOperatorEventGateway getOperatorCoordinatorEventGateway() {
        return new NoOpTaskOperatorEventGateway();
    }
}

