/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler;

import java.net.InetAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.runtime.rest.RestClient;
import org.apache.flink.runtime.rest.handler.RestHandlerSpecification;
import org.apache.flink.runtime.rest.messages.EmptyMessageParameters;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.EmptyResponseBody;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.util.TestMessageHeaders;
import org.apache.flink.runtime.rest.util.TestRestHandler;
import org.apache.flink.runtime.rest.util.TestRestServerEndpoint;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.TestingDispatcherGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelInboundHandler;
import org.apache.flink.util.ConfigurationException;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.concurrent.Executors;
import org.apache.flink.util.concurrent.FutureUtils;
import org.hamcrest.Matcher;
import org.hamcrest.core.StringContains;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class AbstractHandlerITCase
extends TestLogger {
    private static final RestfulGateway mockRestfulGateway = new TestingDispatcherGateway.Builder().build();
    private static final GatewayRetriever<RestfulGateway> mockGatewayRetriever = () -> CompletableFuture.completedFuture(mockRestfulGateway);
    private static final Configuration REST_BASE_CONFIG;
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();

    private RestClient createRestClient(int serverPort) throws ConfigurationException {
        Configuration config = new Configuration(REST_BASE_CONFIG);
        config.setInteger(RestOptions.PORT, serverPort);
        return new RestClient(config, Executors.directExecutor());
    }

    @Test
    public void testOOMErrorMessageEnrichment() throws Exception {
        TestMessageHeaders<EmptyRequestBody, EmptyResponseBody, EmptyMessageParameters> messageHeaders = TestMessageHeaders.emptyBuilder().setTargetRestEndpointURL("/test-handler").build();
        TestRestHandler<RestfulGateway, EmptyRequestBody, EmptyResponseBody, EmptyMessageParameters> testRestHandler = new TestRestHandler<RestfulGateway, EmptyRequestBody, EmptyResponseBody, EmptyMessageParameters>(mockGatewayRetriever, messageHeaders, FutureUtils.completedExceptionally((Throwable)new OutOfMemoryError("Metaspace")));
        try (TestRestServerEndpoint server = TestRestServerEndpoint.builder(REST_BASE_CONFIG).withHandler((RestHandlerSpecification)messageHeaders, (ChannelInboundHandler)testRestHandler).buildAndStart();
             RestClient restClient = this.createRestClient(server.getServerAddress().getPort());){
            CompletableFuture response = restClient.sendRequest(server.getServerAddress().getHostName(), server.getServerAddress().getPort(), messageHeaders, (MessageParameters)EmptyMessageParameters.getInstance(), (RequestBody)EmptyRequestBody.getInstance());
            try {
                response.get();
                Assert.fail((String)"An ExecutionException was expected here being caused by the OutOfMemoryError.");
            }
            catch (ExecutionException e) {
                Assert.assertThat((Object)e.getMessage(), (Matcher)StringContains.containsString((String)"Metaspace. The metaspace out-of-memory error has occurred. "));
            }
        }
    }

    static {
        String loopbackAddress = InetAddress.getLoopbackAddress().getHostAddress();
        Configuration config = new Configuration();
        config.setString(RestOptions.BIND_PORT, "0");
        config.setString(RestOptions.BIND_ADDRESS, loopbackAddress);
        config.setString(RestOptions.ADDRESS, loopbackAddress);
        REST_BASE_CONFIG = config;
    }
}

