/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.flink.runtime.rest.handler.FileUploads;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class FileUploadsTest
extends TestLogger {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testRelativePathRejection() throws IOException {
        Path relative = Paths.get("root", new String[0]);
        try {
            new FileUploads(relative);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testDirectoryScan() throws IOException {
        Path rootDir = Paths.get("root", new String[0]);
        Path rootFile = rootDir.resolve("rootFile");
        Path subDir = rootDir.resolve("sub");
        Path subFile = subDir.resolve("subFile");
        Path tmp = this.temporaryFolder.getRoot().toPath();
        Files.createDirectory(tmp.resolve(rootDir), new FileAttribute[0]);
        Files.createDirectory(tmp.resolve(subDir), new FileAttribute[0]);
        Files.createFile(tmp.resolve(rootFile), new FileAttribute[0]);
        Files.createFile(tmp.resolve(subFile), new FileAttribute[0]);
        try (FileUploads fileUploads = new FileUploads(tmp.resolve(rootDir));){
            Collection detectedFiles = fileUploads.getUploadedFiles().stream().map(File::toPath).collect(Collectors.toList());
            Assert.assertEquals((long)2L, (long)detectedFiles.size());
            Assert.assertTrue((boolean)detectedFiles.contains(tmp.resolve(rootFile)));
            Assert.assertTrue((boolean)detectedFiles.contains(tmp.resolve(subFile)));
        }
    }

    @Test
    public void testEmptyDirectory() throws IOException {
        Path rootDir = Paths.get("root", new String[0]);
        Path tmp = this.temporaryFolder.getRoot().toPath();
        Files.createDirectory(tmp.resolve(rootDir), new FileAttribute[0]);
        try (FileUploads fileUploads = new FileUploads(tmp.resolve(rootDir));){
            Collection detectedFiles = fileUploads.getUploadedFiles();
            Assert.assertEquals((long)0L, (long)detectedFiles.size());
        }
    }

    @Test
    public void testCleanup() throws IOException {
        Path rootDir = Paths.get("root", new String[0]);
        Path rootFile = rootDir.resolve("rootFile");
        Path subDir = rootDir.resolve("sub");
        Path subFile = subDir.resolve("subFile");
        Path tmp = this.temporaryFolder.getRoot().toPath();
        Files.createDirectory(tmp.resolve(rootDir), new FileAttribute[0]);
        Files.createDirectory(tmp.resolve(subDir), new FileAttribute[0]);
        Files.createFile(tmp.resolve(rootFile), new FileAttribute[0]);
        Files.createFile(tmp.resolve(subFile), new FileAttribute[0]);
        try (FileUploads fileUploads = new FileUploads(tmp.resolve(rootDir));){
            Assert.assertTrue((boolean)Files.exists(tmp.resolve(rootDir), new LinkOption[0]));
            Assert.assertTrue((boolean)Files.exists(tmp.resolve(subDir), new LinkOption[0]));
            Assert.assertTrue((boolean)Files.exists(tmp.resolve(rootFile), new LinkOption[0]));
            Assert.assertTrue((boolean)Files.exists(tmp.resolve(subFile), new LinkOption[0]));
        }
        Assert.assertFalse((boolean)Files.exists(tmp.resolve(rootDir), new LinkOption[0]));
        Assert.assertFalse((boolean)Files.exists(tmp.resolve(subDir), new LinkOption[0]));
        Assert.assertFalse((boolean)Files.exists(tmp.resolve(rootFile), new LinkOption[0]));
        Assert.assertFalse((boolean)Files.exists(tmp.resolve(subFile), new LinkOption[0]));
    }
}

