/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.job.metrics;

import org.apache.flink.runtime.rest.HttpMethodWrapper;
import org.apache.flink.runtime.rest.messages.EmptyMessageParameters;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.job.metrics.AbstractMetricsHeaders;
import org.apache.flink.runtime.rest.messages.job.metrics.MetricCollectionResponseBody;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AbstractMetricsHeadersTest
extends TestLogger {
    private AbstractMetricsHeaders<EmptyMessageParameters> metricsHandlerHeaders;

    @Before
    public void setUp() throws Exception {
        this.metricsHandlerHeaders = new AbstractMetricsHeaders<EmptyMessageParameters>(){

            public EmptyMessageParameters getUnresolvedMessageParameters() {
                return EmptyMessageParameters.getInstance();
            }

            public String getTargetRestEndpointURL() {
                return "/";
            }

            public String getDescription() {
                return "";
            }
        };
    }

    @Test
    public void testHttpMethod() {
        Assert.assertThat((Object)this.metricsHandlerHeaders.getHttpMethod(), (Matcher)Matchers.equalTo((Object)HttpMethodWrapper.GET));
    }

    @Test
    public void testResponseStatus() {
        Assert.assertThat((Object)this.metricsHandlerHeaders.getResponseStatusCode(), (Matcher)Matchers.equalTo((Object)HttpResponseStatus.OK));
    }

    @Test
    public void testRequestClass() {
        Assert.assertThat((Object)this.metricsHandlerHeaders.getRequestClass(), (Matcher)Matchers.equalTo(EmptyRequestBody.class));
    }

    @Test
    public void testResponseClass() {
        Assert.assertThat((Object)this.metricsHandlerHeaders.getResponseClass(), (Matcher)Matchers.equalTo(MetricCollectionResponseBody.class));
    }
}

