/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.flink.configuration.AkkaOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.RpcSystem;
import org.apache.flink.runtime.rpc.exceptions.RpcConnectionException;
import org.apache.flink.runtime.taskexecutor.TaskExecutorGateway;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class RpcConnectionTest
extends TestLogger {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectFailure() throws Exception {
        Configuration configuration = new Configuration();
        configuration.set(AkkaOptions.ASK_TIMEOUT_DURATION, (Object)Duration.ofSeconds(10000000L));
        RpcService rpcService = RpcSystem.load().localServiceBuilder(configuration).withBindAddress("localhost").withBindPort(0).createAndStart();
        try {
            CompletableFuture future = rpcService.connect("foo.bar.com.test.invalid", TaskExecutorGateway.class);
            future.get(10000000L, TimeUnit.SECONDS);
            Assert.fail((String)"should never complete normally");
        }
        catch (TimeoutException e) {
            Assert.fail((String)"should not fail with a generic timeout exception");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof RpcConnectionException));
            Assert.assertTrue((String)"wrong error message", (boolean)e.getCause().getMessage().contains("foo.bar.com.test.invalid"));
        }
        catch (Throwable t) {
            Assert.fail((String)("wrong exception: " + t));
        }
        finally {
            rpcService.stopService().get();
        }
    }
}

