/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.scheduler.DefaultPreferredLocationsRetriever;
import org.apache.flink.runtime.scheduler.InputsLocationsRetriever;
import org.apache.flink.runtime.scheduler.TestingInputsLocationsRetriever;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.taskmanager.LocalTaskManagerLocation;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class DefaultPreferredLocationsRetrieverTest
extends TestLogger {
    @Test
    public void testStateLocationsWillBeReturnedIfExist() {
        LocalTaskManagerLocation stateLocation = new LocalTaskManagerLocation();
        TestingInputsLocationsRetriever.Builder locationRetrieverBuilder = new TestingInputsLocationsRetriever.Builder();
        ExecutionVertexID consumerId = new ExecutionVertexID(new JobVertexID(), 0);
        ExecutionVertexID producerId = new ExecutionVertexID(new JobVertexID(), 0);
        locationRetrieverBuilder.connectConsumerToProducer(consumerId, producerId);
        TestingInputsLocationsRetriever inputsLocationsRetriever = locationRetrieverBuilder.build();
        inputsLocationsRetriever.markScheduled(producerId);
        DefaultPreferredLocationsRetriever locationsRetriever = new DefaultPreferredLocationsRetriever(id -> Optional.of(stateLocation), (InputsLocationsRetriever)inputsLocationsRetriever);
        CompletableFuture preferredLocations = locationsRetriever.getPreferredLocations(consumerId, Collections.emptySet());
        Assert.assertThat(preferredLocations.getNow(null), (Matcher)Matchers.contains((Object[])new TaskManagerLocation[]{stateLocation}));
    }

    @Test
    public void testInputLocationsIgnoresEdgeOfTooManyLocations() {
        TestingInputsLocationsRetriever.Builder locationRetrieverBuilder = new TestingInputsLocationsRetriever.Builder();
        ExecutionVertexID consumerId = new ExecutionVertexID(new JobVertexID(), 0);
        int producerParallelism = 9;
        ArrayList<ExecutionVertexID> producerIds = new ArrayList<ExecutionVertexID>(9);
        JobVertexID producerJobVertexId = new JobVertexID();
        for (int i = 0; i < 9; ++i) {
            ExecutionVertexID producerId = new ExecutionVertexID(producerJobVertexId, i);
            locationRetrieverBuilder.connectConsumerToProducer(consumerId, producerId);
            producerIds.add(producerId);
        }
        TestingInputsLocationsRetriever inputsLocationsRetriever = locationRetrieverBuilder.build();
        for (int i = 0; i < 9; ++i) {
            inputsLocationsRetriever.markScheduled((ExecutionVertexID)producerIds.get(i));
        }
        DefaultPreferredLocationsRetriever locationsRetriever = new DefaultPreferredLocationsRetriever(id -> Optional.empty(), (InputsLocationsRetriever)inputsLocationsRetriever);
        CompletableFuture preferredLocations = locationsRetriever.getPreferredLocations(consumerId, Collections.emptySet());
        Assert.assertThat(preferredLocations.getNow(null), (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void testInputLocationsChoosesInputOfFewerLocations() {
        int i;
        TestingInputsLocationsRetriever.Builder locationRetrieverBuilder = new TestingInputsLocationsRetriever.Builder();
        ExecutionVertexID consumerId = new ExecutionVertexID(new JobVertexID(), 0);
        int parallelism1 = 3;
        JobVertexID jobVertexId1 = new JobVertexID();
        ArrayList<ExecutionVertexID> producers1 = new ArrayList<ExecutionVertexID>(parallelism1);
        for (int i2 = 0; i2 < parallelism1; ++i2) {
            ExecutionVertexID producerId = new ExecutionVertexID(jobVertexId1, i2);
            producers1.add(producerId);
            locationRetrieverBuilder.connectConsumerToProducer(consumerId, producerId);
        }
        JobVertexID jobVertexId2 = new JobVertexID();
        int parallelism2 = 5;
        ArrayList<ExecutionVertexID> producers2 = new ArrayList<ExecutionVertexID>(parallelism2);
        for (int i3 = 0; i3 < parallelism2; ++i3) {
            ExecutionVertexID producerId = new ExecutionVertexID(jobVertexId2, i3);
            producers2.add(producerId);
            locationRetrieverBuilder.connectConsumerToProducer(consumerId, producerId);
        }
        TestingInputsLocationsRetriever inputsLocationsRetriever = locationRetrieverBuilder.build();
        ArrayList expectedLocations = new ArrayList(parallelism1);
        for (i = 0; i < parallelism1; ++i) {
            inputsLocationsRetriever.assignTaskManagerLocation((ExecutionVertexID)producers1.get(i));
            expectedLocations.add(inputsLocationsRetriever.getTaskManagerLocation((ExecutionVertexID)producers1.get(i)).get().getNow(null));
        }
        for (i = 0; i < parallelism2; ++i) {
            inputsLocationsRetriever.assignTaskManagerLocation((ExecutionVertexID)producers2.get(i));
        }
        DefaultPreferredLocationsRetriever locationsRetriever = new DefaultPreferredLocationsRetriever(id -> Optional.empty(), (InputsLocationsRetriever)inputsLocationsRetriever);
        CompletableFuture preferredLocations = locationsRetriever.getPreferredLocations(consumerId, Collections.emptySet());
        Assert.assertThat(preferredLocations.getNow(null), (Matcher)Matchers.containsInAnyOrder((Object[])expectedLocations.toArray()));
    }

    @Test
    public void testInputLocationsIgnoresExcludedProducers() {
        TestingInputsLocationsRetriever.Builder locationRetrieverBuilder = new TestingInputsLocationsRetriever.Builder();
        ExecutionVertexID consumerId = new ExecutionVertexID(new JobVertexID(), 0);
        JobVertexID producerJobVertexId = new JobVertexID();
        ExecutionVertexID producerId1 = new ExecutionVertexID(producerJobVertexId, 0);
        locationRetrieverBuilder.connectConsumerToProducer(consumerId, producerId1);
        ExecutionVertexID producerId2 = new ExecutionVertexID(producerJobVertexId, 1);
        locationRetrieverBuilder.connectConsumerToProducer(consumerId, producerId2);
        TestingInputsLocationsRetriever inputsLocationsRetriever = locationRetrieverBuilder.build();
        inputsLocationsRetriever.markScheduled(producerId1);
        inputsLocationsRetriever.markScheduled(producerId2);
        inputsLocationsRetriever.assignTaskManagerLocation(producerId1);
        inputsLocationsRetriever.assignTaskManagerLocation(producerId2);
        DefaultPreferredLocationsRetriever locationsRetriever = new DefaultPreferredLocationsRetriever(id -> Optional.empty(), (InputsLocationsRetriever)inputsLocationsRetriever);
        CompletableFuture preferredLocations = locationsRetriever.getPreferredLocations(consumerId, Collections.singleton(producerId1));
        Assert.assertThat(preferredLocations.getNow(null), (Matcher)Matchers.hasSize((int)1));
        TaskManagerLocation producerLocation2 = inputsLocationsRetriever.getTaskManagerLocation(producerId2).get().getNow(null);
        Assert.assertThat(preferredLocations.getNow(null), (Matcher)Matchers.contains((Object[])new TaskManagerLocation[]{producerLocation2}));
    }
}

