/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adapter;

import java.util.function.Supplier;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.scheduler.adapter.DefaultResultPartition;
import org.apache.flink.runtime.scheduler.strategy.ResultPartitionState;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultResultPartitionTest
extends TestLogger {
    private static final TestResultPartitionStateSupplier resultPartitionState = new TestResultPartitionStateSupplier();
    private final IntermediateResultPartitionID resultPartitionId = new IntermediateResultPartitionID();
    private final IntermediateDataSetID intermediateResultId = new IntermediateDataSetID();
    private DefaultResultPartition resultPartition;

    @Before
    public void setUp() {
        this.resultPartition = new DefaultResultPartition(this.resultPartitionId, this.intermediateResultId, ResultPartitionType.BLOCKING, (Supplier)resultPartitionState);
    }

    @Test
    public void testGetPartitionState() {
        for (ResultPartitionState state : ResultPartitionState.values()) {
            resultPartitionState.setResultPartitionState(state);
            Assert.assertEquals((Object)state, (Object)this.resultPartition.getState());
        }
    }

    private static class TestResultPartitionStateSupplier
    implements Supplier<ResultPartitionState> {
        private ResultPartitionState resultPartitionState;

        private TestResultPartitionStateSupplier() {
        }

        void setResultPartitionState(ResultPartitionState state) {
            this.resultPartitionState = state;
        }

        @Override
        public ResultPartitionState get() {
            return this.resultPartitionState;
        }
    }
}

