/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.benchmark.e2e;

import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.StreamSupport;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutorServiceAdapter;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPoolUtils;
import org.apache.flink.runtime.scheduler.DefaultScheduler;
import org.apache.flink.runtime.scheduler.benchmark.JobConfiguration;
import org.apache.flink.runtime.scheduler.benchmark.e2e.SchedulerEndToEndBenchmarkBase;

public class SchedulingAndDeployingBenchmark
extends SchedulerEndToEndBenchmarkBase {
    private DefaultScheduler scheduler;

    @Override
    public void setup(JobConfiguration jobConfiguration) throws Exception {
        super.setup(jobConfiguration);
        this.scheduler = SchedulingAndDeployingBenchmark.createScheduler(this.jobGraph, this.physicalSlotProvider, this.mainThreadExecutor, this.scheduledExecutorService);
    }

    public void startScheduling() throws Exception {
        CompletableFuture.runAsync(() -> {
            this.scheduler.startScheduling();
            int numberSlots = StreamSupport.stream(this.jobGraph.getVertices().spliterator(), false).mapToInt(JobVertex::getParallelism).sum();
            SlotPoolUtils.tryOfferSlots(this.slotPool, ComponentMainThreadExecutorServiceAdapter.forMainThread(), Collections.nCopies(numberSlots, ResourceProfile.ANY));
        }, (Executor)this.mainThreadExecutor).join();
    }
}

