/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.flink.runtime.state.KeyGroupsStateHandle;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.runtime.state.StateUtil;
import org.apache.flink.util.concurrent.FutureUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class StateUtilTest {
    @Test
    public void testDiscardStateSize() throws Exception {
        Assert.assertEquals((long)1234L, (long)StateUtil.discardStateFuture(CompletableFuture.completedFuture(new TestStateObject(1234))));
        Assert.assertEquals((long)0L, (long)StateUtil.discardStateFuture(null));
        Assert.assertEquals((long)0L, (long)StateUtil.discardStateFuture(new CompletableFuture()));
        Assert.assertEquals((long)0L, (long)StateUtil.discardStateFuture((Future)FutureUtils.completedExceptionally((Throwable)new RuntimeException())));
        Assert.assertEquals((long)0L, (long)StateUtil.discardStateFuture(StateUtilTest.emptyFuture(false, true)));
        Assert.assertEquals((long)0L, (long)StateUtil.discardStateFuture(StateUtilTest.emptyFuture(false, false)));
        Assert.assertEquals((long)0L, (long)StateUtil.discardStateFuture(StateUtilTest.emptyFuture(true, true)));
        Assert.assertEquals((long)0L, (long)StateUtil.discardStateFuture(StateUtilTest.emptyFuture(true, false)));
    }

    @Test
    public void unexpectedStateExceptionForSingleExpectedType() {
        RuntimeException exception = StateUtil.unexpectedStateHandleException(KeyGroupsStateHandle.class, KeyGroupsStateHandle.class);
        Assert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.containsString((String)"Unexpected state handle type, expected one of: class org.apache.flink.runtime.state.KeyGroupsStateHandle, but found: class org.apache.flink.runtime.state.KeyGroupsStateHandle. This can mostly happen when a different StateBackend from the one that was used for taking a checkpoint/savepoint is used when restoring."));
    }

    @Test
    public void unexpectedStateExceptionForMultipleExpectedTypes() {
        RuntimeException exception = StateUtil.unexpectedStateHandleException((Class[])new Class[]{KeyGroupsStateHandle.class, KeyGroupsStateHandle.class}, KeyGroupsStateHandle.class);
        Assert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.containsString((String)"Unexpected state handle type, expected one of: class org.apache.flink.runtime.state.KeyGroupsStateHandle, class org.apache.flink.runtime.state.KeyGroupsStateHandle, but found: class org.apache.flink.runtime.state.KeyGroupsStateHandle. This can mostly happen when a different StateBackend from the one that was used for taking a checkpoint/savepoint is used when restoring."));
    }

    private static <T> Future<T> emptyFuture(final boolean done, final boolean canBeCancelled) {
        return new Future<T>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return canBeCancelled;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return done;
            }

            @Override
            public T get() {
                throw new UnsupportedOperationException();
            }

            @Override
            public T get(long timeout, TimeUnit unit) {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static class TestStateObject
    implements StateObject {
        private static final long serialVersionUID = -8070326169926626355L;
        private final int size;

        private TestStateObject(int size) {
            this.size = size;
        }

        public long getStateSize() {
            return this.size;
        }

        public void discardState() {
        }
    }
}

