/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.memory;

import java.io.IOException;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.runtime.state.memory.ByteStreamStateHandle;
import org.junit.Assert;
import org.junit.Test;

public class ByteStreamStateHandleTest {
    @Test
    public void testStreamSeekAndPos() throws IOException {
        byte[] data = new byte[]{34, 25, 22, 66, 88, 54};
        ByteStreamStateHandle handle = new ByteStreamStateHandle("name", data);
        for (int i = data.length; i >= 0; --i) {
            FSDataInputStream in = handle.openInputStream();
            in.seek((long)i);
            Assert.assertEquals((long)i, (long)((int)in.getPos()));
            if (i < data.length) {
                Assert.assertEquals((long)data[i], (long)in.read());
                Assert.assertEquals((long)(i + 1), (long)((int)in.getPos()));
                continue;
            }
            Assert.assertEquals((long)-1L, (long)in.read());
            Assert.assertEquals((long)i, (long)((int)in.getPos()));
        }
        FSDataInputStream in = handle.openInputStream();
        in.seek((long)data.length);
        Assert.assertEquals((long)-1L, (long)in.read());
        Assert.assertEquals((long)-1L, (long)in.read());
        Assert.assertEquals((long)-1L, (long)in.read());
        Assert.assertEquals((long)data.length, (long)((int)in.getPos()));
    }

    @Test
    public void testStreamSeekOutOfBounds() throws IOException {
        int len = 10;
        ByteStreamStateHandle handle = new ByteStreamStateHandle("name", new byte[10]);
        FSDataInputStream in = handle.openInputStream();
        try {
            in.seek(-2L);
            Assert.fail((String)"should fail with an exception");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        in = handle.openInputStream();
        try {
            in.seek(11L);
            Assert.fail((String)"should fail with an exception");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        in = handle.openInputStream();
        try {
            in.seek(2147483747L);
            Assert.fail((String)"should fail with an exception");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testBulkRead() throws IOException {
        byte[] data = new byte[]{34, 25, 22, 66};
        ByteStreamStateHandle handle = new ByteStreamStateHandle("name", data);
        int targetLen = 8;
        for (int start = 0; start < data.length; ++start) {
            for (int num = 0; num < 8; ++num) {
                FSDataInputStream in = handle.openInputStream();
                in.seek((long)start);
                byte[] target = new byte[8];
                int read = in.read(target, 8 - num, num);
                Assert.assertEquals((long)Math.min(num, data.length - start), (long)read);
                for (int i = 0; i < read; ++i) {
                    Assert.assertEquals((long)data[start + i], (long)target[8 - num + i]);
                }
                int newPos = start + read;
                Assert.assertEquals((long)newPos, (long)((int)in.getPos()));
                Assert.assertEquals((long)(newPos < data.length ? (long)data[newPos] : -1L), (long)in.read());
            }
        }
    }

    @Test
    public void testBulkReadINdexOutOfBounds() throws IOException {
        ByteStreamStateHandle handle = new ByteStreamStateHandle("name", new byte[10]);
        FSDataInputStream in = handle.openInputStream();
        try {
            in.read(new byte[10], -1, 5);
            Assert.fail((String)"should fail with an exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        in = handle.openInputStream();
        try {
            in.read(new byte[10], 10, 5);
            Assert.fail((String)"should fail with an exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        in = handle.openInputStream();
        try {
            in.read(new byte[10], 0, -2);
            Assert.fail((String)"should fail with an exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        in = handle.openInputStream();
        try {
            in.read(new byte[10], 5, 6);
            Assert.fail((String)"should fail with an exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        in = handle.openInputStream();
        try {
            in.read(new byte[10], 5, Integer.MAX_VALUE);
            Assert.fail((String)"should fail with an exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }
}

