/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.testutils;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;

public abstract class CancelableInvokable
extends AbstractInvokable {
    private volatile boolean canceled;
    private final CompletableFuture<Void> terminationFuture = new CompletableFuture();

    protected CancelableInvokable(Environment environment) {
        super(environment);
    }

    public void invoke() throws Exception {
        try {
            this.doInvoke();
            this.terminationFuture.complete(null);
        }
        catch (Exception e) {
            this.terminationFuture.completeExceptionally(e);
            throw e;
        }
    }

    protected abstract void doInvoke() throws Exception;

    public Future<Void> cancel() {
        this.canceled = true;
        return this.terminationFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitUntilCancelled() throws InterruptedException {
        CancelableInvokable cancelableInvokable = this;
        synchronized (cancelableInvokable) {
            while (!this.canceled) {
                ((Object)((Object)this)).wait();
            }
        }
    }
}

