/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.testutils.OneShotLatch;
import org.apache.flink.util.IOUtils;

public class BlockingFSDataInputStream
extends FSDataInputStream {
    private final FSDataInputStream delegate;
    private final OneShotLatch triggerUnblock;
    private final OneShotLatch waitUntilStreamBlocked;
    private final AtomicBoolean closed;
    private final long blockAtPosition;
    private long position;

    public BlockingFSDataInputStream(@Nullable OneShotLatch waitForBlock, @Nullable OneShotLatch triggerUnblock) {
        this(null, waitForBlock, triggerUnblock, 0L);
    }

    public BlockingFSDataInputStream(@Nullable FSDataInputStream delegate, @Nullable OneShotLatch waitForBlock, @Nullable OneShotLatch triggerUnblock) {
        this(delegate, waitForBlock, triggerUnblock, 0L);
    }

    public BlockingFSDataInputStream(@Nullable FSDataInputStream delegate, @Nullable OneShotLatch waitForBlock, @Nullable OneShotLatch triggerUnblock, long blockAtPosition) {
        this.delegate = delegate;
        this.triggerUnblock = triggerUnblock;
        this.waitUntilStreamBlocked = waitForBlock;
        this.blockAtPosition = blockAtPosition;
        if (delegate != null) {
            try {
                this.position = delegate.getPos();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.position = 0L;
        }
        this.closed = new AtomicBoolean(false);
    }

    public void seek(long desired) throws IOException {
        if (this.delegate != null) {
            this.delegate.seek(desired);
        }
        this.position = desired;
    }

    public long getPos() throws IOException {
        return this.position;
    }

    public int read() throws IOException {
        if (this.position == this.blockAtPosition) {
            this.unblockWaiter();
            this.awaitBlocker();
        }
        int val = 0;
        if (this.delegate != null) {
            try {
                val = this.delegate.read();
            }
            catch (IOException ex) {
                this.unblockWaiter();
                throw ex;
            }
        }
        if (this.closed.get()) {
            throw new IOException("Stream closed.");
        }
        ++this.position;
        return val;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int i;
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int c = this.read();
        if (c == -1) {
            return -1;
        }
        b[off] = (byte)c;
        try {
            for (i = 1; i < len && (c = this.read()) != -1; ++i) {
                b[off + i] = (byte)c;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return i;
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            if (this.delegate != null) {
                IOUtils.closeQuietly((AutoCloseable)this.delegate);
            }
            this.unblockAll();
        }
    }

    private void unblockWaiter() {
        if (null != this.waitUntilStreamBlocked) {
            this.waitUntilStreamBlocked.trigger();
        }
    }

    private void awaitBlocker() {
        if (null != this.triggerUnblock) {
            try {
                this.triggerUnblock.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void unblockAll() {
        if (null != this.waitUntilStreamBlocked) {
            this.waitUntilStreamBlocked.trigger();
        }
        if (null != this.triggerUnblock) {
            this.triggerUnblock.trigger();
        }
    }
}

