/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util.jartestprogram;

import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.AggregateOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.util.jartestprogram.StaticData;
import org.apache.flink.util.Collector;

public class WordCountWithInnerClass {
    public static void main(String[] args) throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<String> text = StaticData.getDefaultTextLineDataSet(env);
        AggregateOperator counts = text.flatMap((FlatMapFunction)new Tokenizer()).groupBy(new int[]{0}).sum(1);
        counts.print();
        env.execute("WordCount Example");
    }

    public static final class Tokenizer
    implements FlatMapFunction<String, Tuple2<String, Integer>> {
        public void flatMap(String value, Collector<Tuple2<String, Integer>> out) {
            String[] tokens;
            for (String token : tokens = value.toLowerCase().split("\\W+")) {
                if (token.length() <= 0) continue;
                out.collect((Object)new Tuple2((Object)token, (Object)1));
            }
        }
    }
}

