/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.api.common.resources.CPUResource;
import org.apache.flink.api.common.resources.ExternalResource;
import org.apache.flink.api.common.resources.Resource;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.util.Preconditions;

public class TaskExecutorResourceSpec {
    private final CPUResource cpuCores;
    private final MemorySize taskHeapSize;
    private final MemorySize taskOffHeapSize;
    private final MemorySize networkMemSize;
    private final MemorySize managedMemorySize;
    private final Map<String, ExternalResource> extendedResources;

    public TaskExecutorResourceSpec(CPUResource cpuCores, MemorySize taskHeapSize, MemorySize taskOffHeapSize, MemorySize networkMemSize, MemorySize managedMemorySize, Collection<ExternalResource> extendedResources) {
        this.cpuCores = cpuCores;
        this.taskHeapSize = taskHeapSize;
        this.taskOffHeapSize = taskOffHeapSize;
        this.networkMemSize = networkMemSize;
        this.managedMemorySize = managedMemorySize;
        this.extendedResources = ((Collection)Preconditions.checkNotNull(extendedResources)).stream().filter(resource -> !resource.isZero()).collect(Collectors.toMap(Resource::getName, Function.identity()));
        Preconditions.checkArgument((this.extendedResources.size() == extendedResources.size() ? 1 : 0) != 0, (Object)"Duplicate resource name encountered in external resources.");
    }

    public CPUResource getCpuCores() {
        return this.cpuCores;
    }

    public MemorySize getTaskHeapSize() {
        return this.taskHeapSize;
    }

    public MemorySize getTaskOffHeapSize() {
        return this.taskOffHeapSize;
    }

    public MemorySize getNetworkMemSize() {
        return this.networkMemSize;
    }

    public MemorySize getManagedMemorySize() {
        return this.managedMemorySize;
    }

    public Map<String, ExternalResource> getExtendedResources() {
        return Collections.unmodifiableMap(this.extendedResources);
    }
}

