/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

public enum CheckpointFailureReason {
    PERIODIC_SCHEDULER_SHUTDOWN(true, "Periodic checkpoint scheduler is shut down."),
    ALREADY_QUEUED(true, "Another checkpoint request has already been queued."),
    TOO_MANY_CONCURRENT_CHECKPOINTS(true, "The maximum number of concurrent checkpoints is exceeded"),
    MINIMUM_TIME_BETWEEN_CHECKPOINTS(true, "The minimum time between checkpoints is still pending. Checkpoint will be triggered after the minimum time."),
    NOT_ALL_REQUIRED_TASKS_RUNNING(true, "Not all required tasks are currently running."),
    EXCEPTION(true, "An Exception occurred while triggering the checkpoint."),
    CHECKPOINT_ASYNC_EXCEPTION(false, "Asynchronous task checkpoint failed."),
    CHECKPOINT_EXPIRED(false, "Checkpoint expired before completing."),
    CHECKPOINT_SUBSUMED(false, "Checkpoint has been subsumed."),
    CHECKPOINT_DECLINED(false, "Checkpoint was declined."),
    CHECKPOINT_DECLINED_TASK_NOT_READY(false, "Checkpoint was declined (tasks not ready)"),
    CHECKPOINT_DECLINED_TASK_NOT_CHECKPOINTING(false, "Task does not support checkpointing"),
    CHECKPOINT_DECLINED_SUBSUMED(false, "Checkpoint was canceled because a barrier from newer checkpoint was received."),
    CHECKPOINT_DECLINED_ON_CANCELLATION_BARRIER(false, "Task received cancellation from one of its inputs"),
    CHECKPOINT_DECLINED_ALIGNMENT_LIMIT_EXCEEDED(false, "The checkpoint alignment phase needed to buffer more than the configured maximum bytes"),
    CHECKPOINT_DECLINED_INPUT_END_OF_STREAM(false, "Checkpoint was declined because one input stream is finished"),
    CHECKPOINT_COORDINATOR_SHUTDOWN(false, "CheckpointCoordinator shutdown."),
    CHECKPOINT_COORDINATOR_SUSPEND(false, "Checkpoint Coordinator is suspending."),
    JOB_FAILURE(false, "The job has failed."),
    JOB_FAILOVER_REGION(false, "FailoverRegion is restarting."),
    TASK_CHECKPOINT_FAILURE(false, "Task local checkpoint failure."),
    FINALIZE_CHECKPOINT_FAILURE(false, "Failure to finalize checkpoint."),
    TRIGGER_CHECKPOINT_FAILURE(false, "Trigger checkpoint failure.");

    private final boolean preFlight;
    private final String message;

    private CheckpointFailureReason(boolean isPreFlight, String message) {
        this.preFlight = isPreFlight;
        this.message = message;
    }

    public String message() {
        return this.message;
    }

    public boolean isPreFlight() {
        return this.preFlight;
    }
}

