/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.writer;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.runtime.io.network.api.writer.RecordWriter;
import org.apache.flink.runtime.io.network.api.writer.ResultPartitionWriter;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;
import org.apache.flink.runtime.io.network.buffer.BufferConsumer;
import org.apache.flink.util.Preconditions;

public final class BroadcastRecordWriter<T extends IOReadableWritable>
extends RecordWriter<T> {
    @Nullable
    private BufferBuilder bufferBuilder;
    private boolean randomTriggered;
    private BufferConsumer randomTriggeredConsumer;

    BroadcastRecordWriter(ResultPartitionWriter writer, long timeout, String taskName) {
        super(writer, timeout, taskName);
    }

    @Override
    public void emit(T record) throws IOException, InterruptedException {
        this.broadcastEmit(record);
    }

    @Override
    public void randomEmit(T record) throws IOException, InterruptedException {
        this.randomEmit(record, this.rng.nextInt(this.numberOfChannels));
    }

    @VisibleForTesting
    void randomEmit(T record, int targetChannelIndex) throws IOException, InterruptedException {
        this.tryFinishCurrentBufferBuilder(targetChannelIndex);
        this.randomTriggered = true;
        this.emit(record, targetChannelIndex);
        this.randomTriggered = false;
        if (this.bufferBuilder != null) {
            for (int index = 0; index < this.numberOfChannels; ++index) {
                if (index == targetChannelIndex) continue;
                this.targetPartition.addBufferConsumer(this.randomTriggeredConsumer.copyWithReaderPosition(this.bufferBuilder.getCommittedBytes()), index);
            }
        }
    }

    @Override
    public void broadcastEmit(T record) throws IOException, InterruptedException {
        this.emit(record, 0);
    }

    @Override
    public void flushTargetPartition(int targetChannel) {
        if (this.randomTriggered) {
            super.flushTargetPartition(targetChannel);
        } else {
            this.flushAll();
        }
    }

    @Override
    public BufferBuilder getBufferBuilder(int targetChannel) throws IOException, InterruptedException {
        return this.bufferBuilder != null ? this.bufferBuilder : this.requestNewBufferBuilder(targetChannel);
    }

    @Override
    public BufferBuilder requestNewBufferBuilder(int targetChannel) throws IOException, InterruptedException {
        Preconditions.checkState((this.bufferBuilder == null || this.bufferBuilder.isFinished() ? 1 : 0) != 0);
        BufferBuilder builder = this.targetPartition.getBufferBuilder();
        if (this.randomTriggered) {
            this.randomTriggeredConsumer = builder.createBufferConsumer();
            this.targetPartition.addBufferConsumer(this.randomTriggeredConsumer, targetChannel);
        } else {
            try (BufferConsumer bufferConsumer = builder.createBufferConsumer();){
                for (int channel = 0; channel < this.numberOfChannels; ++channel) {
                    this.targetPartition.addBufferConsumer(bufferConsumer.copy(), channel);
                }
            }
        }
        this.bufferBuilder = builder;
        return builder;
    }

    @Override
    public void tryFinishCurrentBufferBuilder(int targetChannel) {
        if (this.bufferBuilder == null) {
            return;
        }
        BufferBuilder builder = this.bufferBuilder;
        this.bufferBuilder = null;
        this.finishBufferBuilder(builder);
    }

    @Override
    public void emptyCurrentBufferBuilder(int targetChannel) {
        this.bufferBuilder = null;
    }

    @Override
    public void closeBufferBuilder(int targetChannel) {
        this.closeBufferBuilder();
    }

    @Override
    public void clearBuffers() {
        this.closeBufferBuilder();
    }

    private void closeBufferBuilder() {
        if (this.bufferBuilder != null) {
            this.bufferBuilder.finish();
            this.bufferBuilder = null;
        }
    }
}

