/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages;

import java.util.Collection;
import org.apache.flink.runtime.rest.messages.MessageParameter;
import org.apache.flink.runtime.rest.messages.MessagePathParameter;
import org.apache.flink.runtime.rest.messages.MessageQueryParameter;
import org.apache.flink.util.Preconditions;

public abstract class MessageParameters {
    public abstract Collection<MessagePathParameter<?>> getPathParameters();

    public abstract Collection<MessageQueryParameter<?>> getQueryParameters();

    public final boolean isResolved() {
        return this.getPathParameters().stream().filter(MessageParameter::isMandatory).allMatch(MessageParameter::isResolved) && this.getQueryParameters().stream().filter(MessageParameter::isMandatory).allMatch(MessageParameter::isResolved);
    }

    public static String resolveUrl(String genericUrl, MessageParameters parameters) {
        Preconditions.checkState((boolean)parameters.isResolved(), (Object)"Not all mandatory message parameters were resolved.");
        StringBuilder path = new StringBuilder(genericUrl);
        StringBuilder queryParameters = new StringBuilder();
        for (MessageParameter messageParameter : parameters.getPathParameters()) {
            if (!messageParameter.isResolved()) continue;
            int start2 = path.indexOf(':' + messageParameter.getKey());
            String pathValue = (String)Preconditions.checkNotNull((Object)messageParameter.getValueAsString());
            if (start2 == -1) continue;
            path.replace(start2, start2 + messageParameter.getKey().length() + 1, pathValue);
        }
        boolean isFirstQueryParameter = true;
        for (MessageQueryParameter<?> queryParameter : parameters.getQueryParameters()) {
            if (!queryParameter.isResolved()) continue;
            if (isFirstQueryParameter) {
                queryParameters.append('?');
                isFirstQueryParameter = false;
            } else {
                queryParameters.append('&');
            }
            queryParameters.append(queryParameter.getKey());
            queryParameters.append('=');
            queryParameters.append(queryParameter.getValueAsString());
        }
        path.append((CharSequence)queryParameters);
        return path.toString();
    }
}

