/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.checkpoints;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.runtime.checkpoint.AbstractCheckpointStats;
import org.apache.flink.runtime.checkpoint.CheckpointStatsStatus;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStats;
import org.apache.flink.runtime.checkpoint.FailedCheckpointStats;
import org.apache.flink.runtime.checkpoint.PendingCheckpointStats;
import org.apache.flink.runtime.checkpoint.TaskStateStats;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.rest.messages.checkpoints.TaskCheckpointStatistics;
import org.apache.flink.runtime.rest.messages.json.JobVertexIDKeyDeserializer;
import org.apache.flink.runtime.rest.messages.json.JobVertexIDKeySerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonSubTypes;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.flink.util.Preconditions;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="@class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=CompletedCheckpointStatistics.class, name="completed"), @JsonSubTypes.Type(value=FailedCheckpointStatistics.class, name="failed"), @JsonSubTypes.Type(value=PendingCheckpointStatistics.class, name="in_progress")})
public class CheckpointStatistics
implements ResponseBody {
    public static final String FIELD_NAME_ID = "id";
    public static final String FIELD_NAME_STATUS = "status";
    public static final String FIELD_NAME_IS_SAVEPOINT = "is_savepoint";
    public static final String FIELD_NAME_TRIGGER_TIMESTAMP = "trigger_timestamp";
    public static final String FIELD_NAME_LATEST_ACK_TIMESTAMP = "latest_ack_timestamp";
    public static final String FIELD_NAME_STATE_SIZE = "state_size";
    public static final String FIELD_NAME_DURATION = "end_to_end_duration";
    public static final String FIELD_NAME_ALIGNMENT_BUFFERED = "alignment_buffered";
    public static final String FIELD_NAME_NUM_SUBTASKS = "num_subtasks";
    public static final String FIELD_NAME_NUM_ACK_SUBTASKS = "num_acknowledged_subtasks";
    public static final String FIELD_NAME_TASKS = "tasks";
    @JsonProperty(value="id")
    private final long id;
    @JsonProperty(value="status")
    private final CheckpointStatsStatus status;
    @JsonProperty(value="is_savepoint")
    private final boolean savepoint;
    @JsonProperty(value="trigger_timestamp")
    private final long triggerTimestamp;
    @JsonProperty(value="latest_ack_timestamp")
    private final long latestAckTimestamp;
    @JsonProperty(value="state_size")
    private final long stateSize;
    @JsonProperty(value="end_to_end_duration")
    private final long duration;
    @JsonProperty(value="alignment_buffered")
    private final long alignmentBuffered;
    @JsonProperty(value="num_subtasks")
    private final int numSubtasks;
    @JsonProperty(value="num_acknowledged_subtasks")
    private final int numAckSubtasks;
    @JsonProperty(value="tasks")
    @JsonSerialize(keyUsing=JobVertexIDKeySerializer.class)
    private final Map<JobVertexID, TaskCheckpointStatistics> checkpointStatisticsPerTask;

    @JsonCreator
    private CheckpointStatistics(@JsonProperty(value="id") long id, @JsonProperty(value="status") CheckpointStatsStatus status, @JsonProperty(value="is_savepoint") boolean savepoint, @JsonProperty(value="trigger_timestamp") long triggerTimestamp, @JsonProperty(value="latest_ack_timestamp") long latestAckTimestamp, @JsonProperty(value="state_size") long stateSize, @JsonProperty(value="end_to_end_duration") long duration, @JsonProperty(value="alignment_buffered") long alignmentBuffered, @JsonProperty(value="num_subtasks") int numSubtasks, @JsonProperty(value="num_acknowledged_subtasks") int numAckSubtasks, @JsonDeserialize(keyUsing=JobVertexIDKeyDeserializer.class) @JsonProperty(value="tasks") Map<JobVertexID, TaskCheckpointStatistics> checkpointStatisticsPerTask) {
        this.id = id;
        this.status = (CheckpointStatsStatus)((Object)Preconditions.checkNotNull((Object)((Object)status)));
        this.savepoint = savepoint;
        this.triggerTimestamp = triggerTimestamp;
        this.latestAckTimestamp = latestAckTimestamp;
        this.stateSize = stateSize;
        this.duration = duration;
        this.alignmentBuffered = alignmentBuffered;
        this.numSubtasks = numSubtasks;
        this.numAckSubtasks = numAckSubtasks;
        this.checkpointStatisticsPerTask = (Map)Preconditions.checkNotNull(checkpointStatisticsPerTask);
    }

    public long getId() {
        return this.id;
    }

    public CheckpointStatsStatus getStatus() {
        return this.status;
    }

    public boolean isSavepoint() {
        return this.savepoint;
    }

    public long getTriggerTimestamp() {
        return this.triggerTimestamp;
    }

    public long getLatestAckTimestamp() {
        return this.latestAckTimestamp;
    }

    public long getStateSize() {
        return this.stateSize;
    }

    public long getDuration() {
        return this.duration;
    }

    public long getAlignmentBuffered() {
        return this.alignmentBuffered;
    }

    public int getNumSubtasks() {
        return this.numSubtasks;
    }

    public int getNumAckSubtasks() {
        return this.numAckSubtasks;
    }

    @Nullable
    public Map<JobVertexID, TaskCheckpointStatistics> getCheckpointStatisticsPerTask() {
        return this.checkpointStatisticsPerTask;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckpointStatistics that = (CheckpointStatistics)o;
        return this.id == that.id && this.savepoint == that.savepoint && this.triggerTimestamp == that.triggerTimestamp && this.latestAckTimestamp == that.latestAckTimestamp && this.stateSize == that.stateSize && this.duration == that.duration && this.alignmentBuffered == that.alignmentBuffered && this.numSubtasks == that.numSubtasks && this.numAckSubtasks == that.numAckSubtasks && this.status == that.status && Objects.equals(this.checkpointStatisticsPerTask, that.checkpointStatisticsPerTask);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.status, this.savepoint, this.triggerTimestamp, this.latestAckTimestamp, this.stateSize, this.duration, this.alignmentBuffered, this.numSubtasks, this.numAckSubtasks, this.checkpointStatisticsPerTask});
    }

    public static CheckpointStatistics generateCheckpointStatistics(AbstractCheckpointStats checkpointStats, boolean includeTaskCheckpointStatistics) {
        Map<JobVertexID, TaskCheckpointStatistics> checkpointStatisticsPerTask;
        Preconditions.checkNotNull((Object)checkpointStats);
        if (includeTaskCheckpointStatistics) {
            Collection<TaskStateStats> taskStateStats = checkpointStats.getAllTaskStateStats();
            checkpointStatisticsPerTask = new HashMap(taskStateStats.size());
            for (TaskStateStats taskStateStat : taskStateStats) {
                checkpointStatisticsPerTask.put(taskStateStat.getJobVertexId(), new TaskCheckpointStatistics(checkpointStats.getCheckpointId(), checkpointStats.getStatus(), taskStateStat.getLatestAckTimestamp(), taskStateStat.getStateSize(), taskStateStat.getEndToEndDuration(checkpointStats.getTriggerTimestamp()), taskStateStat.getAlignmentBuffered(), taskStateStat.getNumberOfSubtasks(), taskStateStat.getNumberOfAcknowledgedSubtasks()));
            }
        } else {
            checkpointStatisticsPerTask = Collections.emptyMap();
        }
        if (checkpointStats instanceof CompletedCheckpointStats) {
            CompletedCheckpointStats completedCheckpointStats = (CompletedCheckpointStats)checkpointStats;
            return new CompletedCheckpointStatistics(completedCheckpointStats.getCheckpointId(), completedCheckpointStats.getStatus(), completedCheckpointStats.getProperties().isSavepoint(), completedCheckpointStats.getTriggerTimestamp(), completedCheckpointStats.getLatestAckTimestamp(), completedCheckpointStats.getStateSize(), completedCheckpointStats.getEndToEndDuration(), completedCheckpointStats.getAlignmentBuffered(), completedCheckpointStats.getNumberOfSubtasks(), completedCheckpointStats.getNumberOfAcknowledgedSubtasks(), checkpointStatisticsPerTask, completedCheckpointStats.getExternalPath(), completedCheckpointStats.isDiscarded());
        }
        if (checkpointStats instanceof FailedCheckpointStats) {
            FailedCheckpointStats failedCheckpointStats = (FailedCheckpointStats)checkpointStats;
            return new FailedCheckpointStatistics(failedCheckpointStats.getCheckpointId(), failedCheckpointStats.getStatus(), failedCheckpointStats.getProperties().isSavepoint(), failedCheckpointStats.getTriggerTimestamp(), failedCheckpointStats.getLatestAckTimestamp(), failedCheckpointStats.getStateSize(), failedCheckpointStats.getEndToEndDuration(), failedCheckpointStats.getAlignmentBuffered(), failedCheckpointStats.getNumberOfSubtasks(), failedCheckpointStats.getNumberOfAcknowledgedSubtasks(), checkpointStatisticsPerTask, failedCheckpointStats.getFailureTimestamp(), failedCheckpointStats.getFailureMessage());
        }
        if (checkpointStats instanceof PendingCheckpointStats) {
            PendingCheckpointStats pendingCheckpointStats = (PendingCheckpointStats)checkpointStats;
            return new PendingCheckpointStatistics(pendingCheckpointStats.getCheckpointId(), pendingCheckpointStats.getStatus(), pendingCheckpointStats.getProperties().isSavepoint(), pendingCheckpointStats.getTriggerTimestamp(), pendingCheckpointStats.getLatestAckTimestamp(), pendingCheckpointStats.getStateSize(), pendingCheckpointStats.getEndToEndDuration(), pendingCheckpointStats.getAlignmentBuffered(), pendingCheckpointStats.getNumberOfSubtasks(), pendingCheckpointStats.getNumberOfAcknowledgedSubtasks(), checkpointStatisticsPerTask);
        }
        throw new IllegalArgumentException("Given checkpoint stats object of type " + checkpointStats.getClass().getName() + " cannot be converted.");
    }

    public static final class PendingCheckpointStatistics
    extends CheckpointStatistics {
        @JsonCreator
        public PendingCheckpointStatistics(@JsonProperty(value="id") long id, @JsonProperty(value="status") CheckpointStatsStatus status, @JsonProperty(value="is_savepoint") boolean savepoint, @JsonProperty(value="trigger_timestamp") long triggerTimestamp, @JsonProperty(value="latest_ack_timestamp") long latestAckTimestamp, @JsonProperty(value="state_size") long stateSize, @JsonProperty(value="end_to_end_duration") long duration, @JsonProperty(value="alignment_buffered") long alignmentBuffered, @JsonProperty(value="num_subtasks") int numSubtasks, @JsonProperty(value="num_acknowledged_subtasks") int numAckSubtasks, @JsonDeserialize(keyUsing=JobVertexIDKeyDeserializer.class) @JsonProperty(value="tasks") Map<JobVertexID, TaskCheckpointStatistics> checkpointingStatisticsPerTask) {
            super(id, status, savepoint, triggerTimestamp, latestAckTimestamp, stateSize, duration, alignmentBuffered, numSubtasks, numAckSubtasks, checkpointingStatisticsPerTask);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode());
        }
    }

    public static final class FailedCheckpointStatistics
    extends CheckpointStatistics {
        public static final String FIELD_NAME_FAILURE_TIMESTAMP = "failure_timestamp";
        public static final String FIELD_NAME_FAILURE_MESSAGE = "failure_message";
        @JsonProperty(value="failure_timestamp")
        private final long failureTimestamp;
        @JsonProperty(value="failure_message")
        @Nullable
        private final String failureMessage;

        @JsonCreator
        public FailedCheckpointStatistics(@JsonProperty(value="id") long id, @JsonProperty(value="status") CheckpointStatsStatus status, @JsonProperty(value="is_savepoint") boolean savepoint, @JsonProperty(value="trigger_timestamp") long triggerTimestamp, @JsonProperty(value="latest_ack_timestamp") long latestAckTimestamp, @JsonProperty(value="state_size") long stateSize, @JsonProperty(value="end_to_end_duration") long duration, @JsonProperty(value="alignment_buffered") long alignmentBuffered, @JsonProperty(value="num_subtasks") int numSubtasks, @JsonProperty(value="num_acknowledged_subtasks") int numAckSubtasks, @JsonDeserialize(keyUsing=JobVertexIDKeyDeserializer.class) @JsonProperty(value="tasks") Map<JobVertexID, TaskCheckpointStatistics> checkpointingStatisticsPerTask, @JsonProperty(value="failure_timestamp") long failureTimestamp, @JsonProperty(value="failure_message") @Nullable String failureMessage) {
            super(id, status, savepoint, triggerTimestamp, latestAckTimestamp, stateSize, duration, alignmentBuffered, numSubtasks, numAckSubtasks, checkpointingStatisticsPerTask);
            this.failureTimestamp = failureTimestamp;
            this.failureMessage = failureMessage;
        }

        public long getFailureTimestamp() {
            return this.failureTimestamp;
        }

        @Nullable
        public String getFailureMessage() {
            return this.failureMessage;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FailedCheckpointStatistics that = (FailedCheckpointStatistics)o;
            return this.failureTimestamp == that.failureTimestamp && Objects.equals(this.failureMessage, that.failureMessage);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.failureTimestamp, this.failureMessage);
        }
    }

    public static final class CompletedCheckpointStatistics
    extends CheckpointStatistics {
        public static final String FIELD_NAME_EXTERNAL_PATH = "external_path";
        public static final String FIELD_NAME_DISCARDED = "discarded";
        @JsonProperty(value="external_path")
        @Nullable
        private final String externalPath;
        @JsonProperty(value="discarded")
        private final boolean discarded;

        @JsonCreator
        public CompletedCheckpointStatistics(@JsonProperty(value="id") long id, @JsonProperty(value="status") CheckpointStatsStatus status, @JsonProperty(value="is_savepoint") boolean savepoint, @JsonProperty(value="trigger_timestamp") long triggerTimestamp, @JsonProperty(value="latest_ack_timestamp") long latestAckTimestamp, @JsonProperty(value="state_size") long stateSize, @JsonProperty(value="end_to_end_duration") long duration, @JsonProperty(value="alignment_buffered") long alignmentBuffered, @JsonProperty(value="num_subtasks") int numSubtasks, @JsonProperty(value="num_acknowledged_subtasks") int numAckSubtasks, @JsonDeserialize(keyUsing=JobVertexIDKeyDeserializer.class) @JsonProperty(value="tasks") Map<JobVertexID, TaskCheckpointStatistics> checkpointingStatisticsPerTask, @JsonProperty(value="external_path") @Nullable String externalPath, @JsonProperty(value="discarded") boolean discarded) {
            super(id, status, savepoint, triggerTimestamp, latestAckTimestamp, stateSize, duration, alignmentBuffered, numSubtasks, numAckSubtasks, checkpointingStatisticsPerTask);
            this.externalPath = externalPath;
            this.discarded = discarded;
        }

        @Nullable
        public String getExternalPath() {
            return this.externalPath;
        }

        public boolean isDiscarded() {
            return this.discarded;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CompletedCheckpointStatistics that = (CompletedCheckpointStatistics)o;
            return this.discarded == that.discarded && Objects.equals(this.externalPath, that.externalPath);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.externalPath, this.discarded);
        }
    }
}

