/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.configuration.WebOptions;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.plugin.PluginManager;
import org.apache.flink.core.plugin.PluginUtils;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.blob.BlobCacheService;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.entrypoint.ClusterConfiguration;
import org.apache.flink.runtime.entrypoint.ClusterConfigurationParserFactory;
import org.apache.flink.runtime.entrypoint.FlinkParseException;
import org.apache.flink.runtime.entrypoint.parser.CommandLineParser;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServicesUtils;
import org.apache.flink.runtime.io.network.partition.TaskExecutorPartitionTrackerImpl;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalException;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.MetricRegistryConfiguration;
import org.apache.flink.runtime.metrics.MetricRegistryImpl;
import org.apache.flink.runtime.metrics.ReporterSetup;
import org.apache.flink.runtime.metrics.groups.TaskManagerMetricGroup;
import org.apache.flink.runtime.metrics.util.MetricUtils;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.akka.AkkaRpcServiceUtils;
import org.apache.flink.runtime.security.ExitTrappingSecurityManager;
import org.apache.flink.runtime.security.SecurityConfiguration;
import org.apache.flink.runtime.security.SecurityUtils;
import org.apache.flink.runtime.taskexecutor.BackPressureSampleService;
import org.apache.flink.runtime.taskexecutor.HostBindPolicy;
import org.apache.flink.runtime.taskexecutor.TaskExecutor;
import org.apache.flink.runtime.taskexecutor.TaskExecutorResourceSpec;
import org.apache.flink.runtime.taskexecutor.TaskExecutorResourceUtils;
import org.apache.flink.runtime.taskexecutor.TaskExecutorToServiceAdapter;
import org.apache.flink.runtime.taskexecutor.TaskManagerConfiguration;
import org.apache.flink.runtime.taskexecutor.TaskManagerServices;
import org.apache.flink.runtime.taskexecutor.TaskManagerServicesConfiguration;
import org.apache.flink.runtime.taskmanager.MemoryLogger;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.runtime.util.ExecutorThreadFactory;
import org.apache.flink.runtime.util.Hardware;
import org.apache.flink.runtime.util.JvmShutdownSafeguard;
import org.apache.flink.runtime.util.LeaderRetrievalUtils;
import org.apache.flink.runtime.util.SignalHandler;
import org.apache.flink.util.AutoCloseableAsync;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.ExecutorUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskManagerRunner
implements FatalErrorHandler,
AutoCloseableAsync {
    private static final Logger LOG = LoggerFactory.getLogger(TaskManagerRunner.class);
    private static final long FATAL_ERROR_SHUTDOWN_TIMEOUT_MS = 10000L;
    private static final int STARTUP_FAILURE_RETURN_CODE = 1;
    public static final int RUNTIME_FAILURE_RETURN_CODE = 2;
    private final Object lock = new Object();
    private final Configuration configuration;
    private final ResourceID resourceId;
    private final Time timeout;
    private final RpcService rpcService;
    private final HighAvailabilityServices highAvailabilityServices;
    private final MetricRegistryImpl metricRegistry;
    private final BlobCacheService blobCacheService;
    private final ExecutorService executor;
    private final TaskExecutorService taskExecutorService;
    private final CompletableFuture<Void> terminationFuture;
    private boolean shutdown;

    public TaskManagerRunner(Configuration configuration, ResourceID resourceId, TaskExecutorServiceFactory taskExecutorServiceFactory) throws Exception {
        this.configuration = (Configuration)Preconditions.checkNotNull((Object)configuration);
        this.resourceId = (ResourceID)Preconditions.checkNotNull((Object)resourceId);
        this.timeout = AkkaUtils.getTimeoutAsTime(configuration);
        this.executor = Executors.newScheduledThreadPool(Hardware.getNumberCPUCores(), new ExecutorThreadFactory("taskmanager-future"));
        this.highAvailabilityServices = HighAvailabilityServicesUtils.createHighAvailabilityServices(configuration, this.executor, HighAvailabilityServicesUtils.AddressResolution.TRY_ADDRESS_RESOLUTION);
        this.rpcService = TaskManagerRunner.createRpcService(configuration, this.highAvailabilityServices);
        HeartbeatServices heartbeatServices = HeartbeatServices.fromConfiguration(configuration);
        this.metricRegistry = new MetricRegistryImpl(MetricRegistryConfiguration.fromConfiguration(configuration), ReporterSetup.fromConfiguration(configuration));
        RpcService metricQueryServiceRpcService = MetricUtils.startMetricsRpcService(configuration, this.rpcService.getAddress());
        this.metricRegistry.startQueryService(metricQueryServiceRpcService, resourceId);
        this.blobCacheService = new BlobCacheService(configuration, this.highAvailabilityServices.createBlobStore(), null);
        this.taskExecutorService = taskExecutorServiceFactory.createTaskExecutor(this.configuration, this.resourceId, this.rpcService, this.highAvailabilityServices, heartbeatServices, this.metricRegistry, this.blobCacheService, false, this);
        this.terminationFuture = new CompletableFuture();
        this.shutdown = false;
        this.handleUnexpectedTaskExecutorServiceTermination();
        MemoryLogger.startIfConfigured(LOG, configuration, this.terminationFuture);
    }

    private void handleUnexpectedTaskExecutorServiceTermination() {
        this.taskExecutorService.getTerminationFuture().whenComplete((unused, throwable) -> {
            Object object = this.lock;
            synchronized (object) {
                if (!this.shutdown) {
                    this.onFatalError(new FlinkException("Unexpected termination of the TaskExecutor.", throwable));
                }
            }
        });
    }

    public void start() throws Exception {
        this.taskExecutorService.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> closeAsync() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.shutdown) {
                this.shutdown = true;
                CompletableFuture taskManagerTerminationFuture = this.taskExecutorService.closeAsync();
                CompletableFuture<Void> serviceTerminationFuture = FutureUtils.composeAfterwards(taskManagerTerminationFuture, this::shutDownServices);
                serviceTerminationFuture.whenComplete((ignored, throwable) -> {
                    if (throwable != null) {
                        this.terminationFuture.completeExceptionally((Throwable)throwable);
                    } else {
                        this.terminationFuture.complete(null);
                    }
                });
            }
        }
        return this.terminationFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Void> shutDownServices() {
        Object object = this.lock;
        synchronized (object) {
            ArrayList terminationFutures = new ArrayList(3);
            Exception exception = null;
            try {
                this.blobCacheService.close();
            }
            catch (Exception e) {
                exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, exception);
            }
            try {
                this.metricRegistry.shutdown();
            }
            catch (Exception e) {
                exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
            }
            try {
                this.highAvailabilityServices.close();
            }
            catch (Exception e) {
                exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
            }
            terminationFutures.add(this.rpcService.stopService());
            terminationFutures.add(ExecutorUtils.nonBlockingShutdown((long)this.timeout.toMilliseconds(), (TimeUnit)TimeUnit.MILLISECONDS, (ExecutorService[])new ExecutorService[]{this.executor}));
            if (exception != null) {
                terminationFutures.add(FutureUtils.completedExceptionally(exception));
            }
            return FutureUtils.completeAll(terminationFutures);
        }
    }

    public CompletableFuture<Void> getTerminationFuture() {
        return this.terminationFuture;
    }

    @Override
    public void onFatalError(Throwable exception) {
        Throwable enrichedException = ExceptionUtils.tryEnrichTaskManagerError((Throwable)exception);
        LOG.error("Fatal error occurred while executing the TaskManager. Shutting it down...", enrichedException);
        if (ExceptionUtils.isJvmFatalOrOutOfMemoryError((Throwable)enrichedException) && !ExceptionUtils.isMetaspaceOutOfMemoryError((Throwable)enrichedException)) {
            this.terminateJVM();
        } else {
            this.closeAsync();
            FutureUtils.orTimeout(this.terminationFuture, 10000L, TimeUnit.MILLISECONDS);
            this.terminationFuture.whenComplete((ignored, throwable) -> this.terminateJVM());
        }
    }

    private void terminateJVM() {
        System.exit(2);
    }

    public static void main(String[] args) throws Exception {
        EnvironmentInformation.logEnvironmentInfo(LOG, "TaskManager", args);
        SignalHandler.register(LOG);
        JvmShutdownSafeguard.installAsShutdownHook(LOG);
        long maxOpenFileHandles = EnvironmentInformation.getOpenFileHandlesLimit();
        if (maxOpenFileHandles != -1L) {
            LOG.info("Maximum number of open file descriptors is {}.", (Object)maxOpenFileHandles);
        } else {
            LOG.info("Cannot determine the maximum number of open file descriptors");
        }
        TaskManagerRunner.runTaskManagerSecurely(args, ResourceID.generate());
    }

    public static Configuration loadConfiguration(String[] args) throws FlinkParseException {
        ClusterConfiguration clusterConfiguration;
        CommandLineParser<ClusterConfiguration> commandLineParser = new CommandLineParser<ClusterConfiguration>(new ClusterConfigurationParserFactory());
        try {
            clusterConfiguration = commandLineParser.parse(args);
        }
        catch (FlinkParseException e) {
            LOG.error("Could not parse the command line options.", (Throwable)((Object)e));
            commandLineParser.printHelp(TaskManagerRunner.class.getSimpleName());
            throw e;
        }
        Configuration dynamicProperties = ConfigurationUtils.createConfiguration((Properties)clusterConfiguration.getDynamicProperties());
        return GlobalConfiguration.loadConfiguration((String)clusterConfiguration.getConfigDir(), (Configuration)dynamicProperties);
    }

    public static void runTaskManager(Configuration configuration, ResourceID resourceId) throws Exception {
        TaskManagerRunner taskManagerRunner = new TaskManagerRunner(configuration, resourceId, TaskManagerRunner::createTaskExecutorService);
        taskManagerRunner.start();
    }

    public static void runTaskManagerSecurely(String[] args, ResourceID resourceID) {
        try {
            Configuration configuration = TaskManagerRunner.loadConfiguration(args);
            TaskManagerRunner.runTaskManagerSecurely(configuration, resourceID);
        }
        catch (Throwable t) {
            Throwable strippedThrowable = ExceptionUtils.stripException((Throwable)t, UndeclaredThrowableException.class);
            LOG.error("TaskManager initialization failed.", strippedThrowable);
            System.exit(1);
        }
    }

    public static void runTaskManagerSecurely(Configuration configuration, ResourceID resourceID) throws Exception {
        ExitTrappingSecurityManager.replaceGracefulExitWithHaltIfConfigured(configuration);
        PluginManager pluginManager = PluginUtils.createPluginManagerFromRootFolder((Configuration)configuration);
        FileSystem.initialize((Configuration)configuration, (PluginManager)pluginManager);
        SecurityUtils.install(new SecurityConfiguration(configuration));
        SecurityUtils.getInstalledContext().runSecured(() -> {
            TaskManagerRunner.runTaskManager(configuration, resourceID);
            return null;
        });
    }

    public static TaskExecutorService createTaskExecutorService(Configuration configuration, ResourceID resourceID, RpcService rpcService, HighAvailabilityServices highAvailabilityServices, HeartbeatServices heartbeatServices, MetricRegistry metricRegistry, BlobCacheService blobCacheService, boolean localCommunicationOnly, FatalErrorHandler fatalErrorHandler) throws Exception {
        TaskExecutor taskExecutor = TaskManagerRunner.startTaskManager(configuration, resourceID, rpcService, highAvailabilityServices, heartbeatServices, metricRegistry, blobCacheService, localCommunicationOnly, fatalErrorHandler);
        return TaskExecutorToServiceAdapter.createFor(taskExecutor);
    }

    public static TaskExecutor startTaskManager(Configuration configuration, ResourceID resourceID, RpcService rpcService, HighAvailabilityServices highAvailabilityServices, HeartbeatServices heartbeatServices, MetricRegistry metricRegistry, BlobCacheService blobCacheService, boolean localCommunicationOnly, FatalErrorHandler fatalErrorHandler) throws Exception {
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkNotNull((Object)resourceID);
        Preconditions.checkNotNull((Object)rpcService);
        Preconditions.checkNotNull((Object)highAvailabilityServices);
        LOG.info("Starting TaskManager with ResourceID: {}", (Object)resourceID);
        InetAddress remoteAddress = InetAddress.getByName(rpcService.getAddress());
        TaskExecutorResourceSpec taskExecutorResourceSpec = TaskExecutorResourceUtils.resourceSpecFromConfig(configuration);
        TaskManagerServicesConfiguration taskManagerServicesConfiguration = TaskManagerServicesConfiguration.fromConfiguration(configuration, resourceID, remoteAddress, localCommunicationOnly, taskExecutorResourceSpec);
        Tuple2<TaskManagerMetricGroup, MetricGroup> taskManagerMetricGroup = MetricUtils.instantiateTaskManagerMetricGroup(metricRegistry, TaskManagerLocation.getHostName(remoteAddress), resourceID, taskManagerServicesConfiguration.getSystemResourceMetricsProbingInterval());
        ExecutorService ioExecutor = Executors.newFixedThreadPool(taskManagerServicesConfiguration.getNumIoThreads(), new ExecutorThreadFactory("flink-taskexecutor-io"));
        TaskManagerServices taskManagerServices = TaskManagerServices.fromConfiguration(taskManagerServicesConfiguration, (MetricGroup)taskManagerMetricGroup.f1, ioExecutor);
        TaskManagerConfiguration taskManagerConfiguration = TaskManagerConfiguration.fromConfiguration(configuration, taskExecutorResourceSpec);
        String metricQueryServiceAddress = metricRegistry.getMetricQueryServiceGatewayRpcAddress();
        return new TaskExecutor(rpcService, taskManagerConfiguration, highAvailabilityServices, taskManagerServices, heartbeatServices, (TaskManagerMetricGroup)taskManagerMetricGroup.f0, metricQueryServiceAddress, blobCacheService, fatalErrorHandler, new TaskExecutorPartitionTrackerImpl(taskManagerServices.getShuffleEnvironment()), TaskManagerRunner.createBackPressureSampleService(configuration, rpcService.getScheduledExecutor()));
    }

    static BackPressureSampleService createBackPressureSampleService(Configuration configuration, ScheduledExecutor scheduledExecutor) {
        return new BackPressureSampleService(configuration.getInteger(WebOptions.BACKPRESSURE_NUM_SAMPLES), Time.milliseconds((long)configuration.getInteger(WebOptions.BACKPRESSURE_DELAY)), scheduledExecutor);
    }

    public static RpcService createRpcService(Configuration configuration, HighAvailabilityServices haServices) throws Exception {
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkNotNull((Object)haServices);
        String taskManagerAddress = TaskManagerRunner.determineTaskManagerBindAddress(configuration, haServices);
        String portRangeDefinition = configuration.getString(TaskManagerOptions.RPC_PORT);
        return AkkaRpcServiceUtils.createRpcService(taskManagerAddress, portRangeDefinition, configuration);
    }

    private static String determineTaskManagerBindAddress(Configuration configuration, HighAvailabilityServices haServices) throws Exception {
        String configuredTaskManagerHostname = configuration.getString(TaskManagerOptions.HOST);
        if (configuredTaskManagerHostname != null) {
            LOG.info("Using configured hostname/address for TaskManager: {}.", (Object)configuredTaskManagerHostname);
            return configuredTaskManagerHostname;
        }
        return TaskManagerRunner.determineTaskManagerBindAddressByConnectingToResourceManager(configuration, haServices);
    }

    private static String determineTaskManagerBindAddressByConnectingToResourceManager(Configuration configuration, HighAvailabilityServices haServices) throws LeaderRetrievalException {
        Duration lookupTimeout = AkkaUtils.getLookupTimeout(configuration);
        InetAddress taskManagerAddress = LeaderRetrievalUtils.findConnectingAddress(haServices.getResourceManagerLeaderRetriever(), lookupTimeout);
        LOG.info("TaskManager will use hostname/address '{}' ({}) for communication.", (Object)taskManagerAddress.getHostName(), (Object)taskManagerAddress.getHostAddress());
        HostBindPolicy bindPolicy = HostBindPolicy.fromString(configuration.getString(TaskManagerOptions.HOST_BIND_POLICY));
        return bindPolicy == HostBindPolicy.IP ? taskManagerAddress.getHostAddress() : taskManagerAddress.getHostName();
    }

    public static interface TaskExecutorService
    extends AutoCloseableAsync {
        public void start();

        public CompletableFuture<Void> getTerminationFuture();
    }

    public static interface TaskExecutorServiceFactory {
        public TaskExecutorService createTaskExecutor(Configuration var1, ResourceID var2, RpcService var3, HighAvailabilityServices var4, HeartbeatServices var5, MetricRegistry var6, BlobCacheService var7, boolean var8, FatalErrorHandler var9) throws Exception;
    }
}

