/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Properties;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.runtime.util.Hardware;
import org.apache.flink.util.OperatingSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentInformation {
    private static final Logger LOG = LoggerFactory.getLogger(EnvironmentInformation.class);
    public static final String UNKNOWN = "<unknown>";

    public static String getVersion() {
        String version = EnvironmentInformation.class.getPackage().getImplementationVersion();
        return version != null ? version : UNKNOWN;
    }

    public static RevisionInformation getRevisionInformation() {
        String revision = UNKNOWN;
        String commitDate = UNKNOWN;
        try (InputStream propFile = EnvironmentInformation.class.getClassLoader().getResourceAsStream(".version.properties");){
            if (propFile != null) {
                Properties properties = new Properties();
                properties.load(propFile);
                String propRevision = properties.getProperty("git.commit.id.abbrev");
                String propCommitDate = properties.getProperty("git.commit.time");
                revision = propRevision != null ? propRevision : UNKNOWN;
                commitDate = propCommitDate != null ? propCommitDate : UNKNOWN;
            }
        }
        catch (Throwable t) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cannot determine code revision: Unable to read version property file.", t);
            }
            LOG.info("Cannot determine code revision: Unable to read version property file.");
        }
        return new RevisionInformation(revision, commitDate);
    }

    public static String getHadoopUser() {
        try {
            Class<?> ugiClass = Class.forName("org.apache.hadoop.security.UserGroupInformation", false, EnvironmentInformation.class.getClassLoader());
            Method currentUserMethod = ugiClass.getMethod("getCurrentUser", new Class[0]);
            Method shortUserNameMethod = ugiClass.getMethod("getShortUserName", new Class[0]);
            Object ugi = currentUserMethod.invoke(null, new Object[0]);
            return (String)shortUserNameMethod.invoke(ugi, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            return "<no hadoop dependency found>";
        }
        catch (LinkageError e) {
            LOG.debug("Cannot determine user/group information using Hadoop utils. Hadoop classes not loaded or compatible", (Throwable)e);
        }
        catch (Throwable t) {
            LOG.warn("Error while accessing user/group information via Hadoop utils.", t);
        }
        return UNKNOWN;
    }

    public static long getMaxJvmHeapMemory() {
        long maxMemory = Runtime.getRuntime().maxMemory();
        if (maxMemory != Long.MAX_VALUE) {
            return maxMemory;
        }
        long physicalMemory = Hardware.getSizeOfPhysicalMemory();
        if (physicalMemory != -1L) {
            return physicalMemory / 4L;
        }
        throw new RuntimeException("Could not determine the amount of free memory.\nPlease set the maximum memory for the JVM, e.g. -Xmx512M for 512 megabytes.");
    }

    public static long getSizeOfFreeHeapMemoryWithDefrag() {
        System.gc();
        return EnvironmentInformation.getSizeOfFreeHeapMemory();
    }

    public static long getSizeOfFreeHeapMemory() {
        Runtime r = Runtime.getRuntime();
        return EnvironmentInformation.getMaxJvmHeapMemory() - r.totalMemory() + r.freeMemory();
    }

    public static String getJvmVersion() {
        try {
            RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
            return bean.getVmName() + " - " + bean.getVmVendor() + " - " + bean.getSpecVersion() + '/' + bean.getVmVersion();
        }
        catch (Throwable t) {
            return UNKNOWN;
        }
    }

    public static String getJvmStartupOptions() {
        try {
            RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
            StringBuilder bld = new StringBuilder();
            for (String s : bean.getInputArguments()) {
                bld.append(s).append(' ');
            }
            return bld.toString();
        }
        catch (Throwable t) {
            return UNKNOWN;
        }
    }

    public static String[] getJvmStartupOptionsArray() {
        try {
            RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
            List<String> options = bean.getInputArguments();
            return options.toArray(new String[options.size()]);
        }
        catch (Throwable t) {
            return new String[0];
        }
    }

    public static String getTemporaryFileDirectory() {
        return System.getProperty("java.io.tmpdir");
    }

    public static long getOpenFileHandlesLimit() {
        Class<?> sunBeanClass;
        if (OperatingSystem.isWindows()) {
            return -1L;
        }
        try {
            sunBeanClass = Class.forName("com.sun.management.UnixOperatingSystemMXBean");
        }
        catch (ClassNotFoundException e) {
            return -1L;
        }
        try {
            Method fhLimitMethod = sunBeanClass.getMethod("getMaxFileDescriptorCount", new Class[0]);
            Object result = fhLimitMethod.invoke((Object)ManagementFactory.getOperatingSystemMXBean(), new Object[0]);
            return (Long)result;
        }
        catch (Throwable t) {
            LOG.warn("Unexpected error when accessing file handle limit", t);
            return -1L;
        }
    }

    public static void logEnvironmentInfo(Logger log, String componentName, String[] commandLineArgs) {
        if (log.isInfoEnabled()) {
            RevisionInformation rev = EnvironmentInformation.getRevisionInformation();
            String version = EnvironmentInformation.getVersion();
            String jvmVersion = EnvironmentInformation.getJvmVersion();
            String[] options = EnvironmentInformation.getJvmStartupOptionsArray();
            String javaHome = System.getenv("JAVA_HOME");
            String inheritedLogs = System.getenv("FLINK_INHERITED_LOGS");
            long maxHeapMegabytes = EnvironmentInformation.getMaxJvmHeapMemory() >>> 20;
            if (inheritedLogs != null) {
                log.info("--------------------------------------------------------------------------------");
                log.info(" Preconfiguration: ");
                log.info(inheritedLogs);
            }
            log.info("--------------------------------------------------------------------------------");
            log.info(" Starting " + componentName + " (Version: " + version + ", Rev:" + rev.commitId + ", Date:" + rev.commitDate + ")");
            log.info(" OS current user: " + System.getProperty("user.name"));
            log.info(" Current Hadoop/Kerberos user: " + EnvironmentInformation.getHadoopUser());
            log.info(" JVM: " + jvmVersion);
            log.info(" Maximum heap size: " + maxHeapMegabytes + " MiBytes");
            log.info(" JAVA_HOME: " + (javaHome == null ? "(not set)" : javaHome));
            String hadoopVersionString = EnvironmentInformation.getHadoopVersionString();
            if (hadoopVersionString != null) {
                log.info(" Hadoop version: " + hadoopVersionString);
            } else {
                log.info(" No Hadoop Dependency available");
            }
            if (options.length == 0) {
                log.info(" JVM Options: (none)");
            } else {
                log.info(" JVM Options:");
                for (String s : options) {
                    log.info("    " + s);
                }
            }
            if (commandLineArgs == null || commandLineArgs.length == 0) {
                log.info(" Program Arguments: (none)");
            } else {
                log.info(" Program Arguments:");
                for (String s : commandLineArgs) {
                    if (GlobalConfiguration.isSensitive((String)s)) {
                        log.info("    ****** (sensitive information)");
                        continue;
                    }
                    log.info("    " + s);
                }
            }
            log.info(" Classpath: " + System.getProperty("java.class.path"));
            log.info("--------------------------------------------------------------------------------");
        }
    }

    public static String getHadoopVersionString() {
        try {
            Class<?> versionInfoClass = Class.forName("org.apache.hadoop.util.VersionInfo", false, EnvironmentInformation.class.getClassLoader());
            Method method = versionInfoClass.getMethod("getVersion", new Class[0]);
            return (String)method.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            return null;
        }
        catch (Throwable e) {
            LOG.error("Cannot invoke VersionInfo.getVersion reflectively.", e);
            return null;
        }
    }

    private EnvironmentInformation() {
    }

    public static class RevisionInformation {
        public final String commitId;
        public final String commitDate;

        public RevisionInformation(String commitId, String commitDate) {
            this.commitId = commitId;
            this.commitDate = commitDate;
        }
    }
}

