/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.BlobServerOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobCachePutTest;
import org.apache.flink.runtime.blob.BlobCacheService;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobKeyTest;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobServerDeleteTest;
import org.apache.flink.runtime.blob.BlobServerGetTest;
import org.apache.flink.runtime.blob.BlobServerPutTest;
import org.apache.flink.runtime.blob.BlobService;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.BlobView;
import org.apache.flink.runtime.blob.TransientBlobKey;
import org.apache.flink.runtime.blob.VoidBlobStore;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.OperatingSystem;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class BlobCacheDeleteTest
extends TestLogger {
    private final Random rnd = new Random();
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testDeleteTransient1() throws IOException {
        this.testDelete(null, new JobID());
    }

    @Test
    public void testDeleteTransient2() throws IOException {
        this.testDelete(new JobID(), null);
    }

    @Test
    public void testDeleteTransient3() throws IOException {
        this.testDelete(null, null);
    }

    @Test
    public void testDeleteTransient4() throws IOException {
        this.testDelete(new JobID(), new JobID());
    }

    @Test
    public void testDeleteTransient5() throws IOException {
        JobID jobId = new JobID();
        this.testDelete(jobId, jobId);
    }

    private void testDelete(@Nullable JobID jobId1, @Nullable JobID jobId2) throws IOException {
        Configuration config = new Configuration();
        config.setString(BlobServerOptions.STORAGE_DIRECTORY, this.temporaryFolder.newFolder().getAbsolutePath());
        try (BlobServer server = new BlobServer(config, (BlobStore)new VoidBlobStore());
             BlobCacheService cache = new BlobCacheService(config, (BlobView)new VoidBlobStore(), new InetSocketAddress("localhost", server.getPort()));){
            server.start();
            byte[] data = new byte[2000000];
            this.rnd.nextBytes(data);
            byte[] data2 = Arrays.copyOf(data, data.length);
            data2[0] = (byte)(data2[0] ^ 1);
            TransientBlobKey key1 = (TransientBlobKey)BlobServerPutTest.put((BlobService)server, jobId1, data, BlobKey.BlobType.TRANSIENT_BLOB);
            Assert.assertNotNull((Object)key1);
            TransientBlobKey key2a = (TransientBlobKey)BlobServerPutTest.put((BlobService)server, jobId2, data, BlobKey.BlobType.TRANSIENT_BLOB);
            Assert.assertNotNull((Object)key2a);
            BlobKeyTest.verifyKeyDifferentHashEquals((BlobKey)key1, (BlobKey)key2a);
            TransientBlobKey key2b = (TransientBlobKey)BlobServerPutTest.put((BlobService)server, jobId2, data2, BlobKey.BlobType.TRANSIENT_BLOB);
            Assert.assertNotNull((Object)key2b);
            BlobKeyTest.verifyKeyDifferentHashDifferent((BlobKey)key1, (BlobKey)key2b);
            Assert.assertTrue((boolean)BlobServerDeleteTest.delete((BlobService)cache, jobId1, key1));
            Assert.assertTrue((boolean)server.getStorageLocation(jobId1, (BlobKey)key1).exists());
            Assert.assertTrue((boolean)server.deleteInternal(jobId1, key1));
            BlobServerGetTest.verifyDeleted((BlobService)cache, jobId1, (BlobKey)key1);
            BlobServerPutTest.verifyContents((BlobService)server, jobId2, (BlobKey)key2a, data);
            BlobServerPutTest.verifyContents((BlobService)server, jobId2, (BlobKey)key2b, data2);
            Assert.assertTrue((boolean)BlobServerDeleteTest.delete((BlobService)cache, jobId2, key2a));
            Assert.assertTrue((boolean)server.getStorageLocation(jobId2, (BlobKey)key2a).exists());
            Assert.assertTrue((boolean)server.deleteInternal(jobId2, key2a));
            BlobServerGetTest.verifyDeleted((BlobService)cache, jobId2, (BlobKey)key2a);
            BlobServerPutTest.verifyContents((BlobService)server, jobId2, (BlobKey)key2b, data2);
            Assert.assertTrue((boolean)BlobServerDeleteTest.delete((BlobService)cache, jobId2, key2b));
            Assert.assertTrue((boolean)server.getStorageLocation(jobId2, (BlobKey)key2b).exists());
            Assert.assertTrue((boolean)server.deleteInternal(jobId2, key2b));
            BlobServerGetTest.verifyDeleted((BlobService)cache, jobId2, (BlobKey)key2b);
        }
    }

    @Test
    public void testDeleteTransientAlreadyDeletedNoJob() throws IOException {
        this.testDeleteTransientAlreadyDeleted(null);
    }

    @Test
    public void testDeleteTransientAlreadyDeletedForJob() throws IOException {
        this.testDeleteTransientAlreadyDeleted(new JobID());
    }

    private void testDeleteTransientAlreadyDeleted(@Nullable JobID jobId) throws IOException {
        Configuration config = new Configuration();
        config.setString(BlobServerOptions.STORAGE_DIRECTORY, this.temporaryFolder.newFolder().getAbsolutePath());
        try (BlobServer server = new BlobServer(config, (BlobStore)new VoidBlobStore());
             BlobCacheService cache = new BlobCacheService(config, (BlobView)new VoidBlobStore(), new InetSocketAddress("localhost", server.getPort()));){
            server.start();
            byte[] data = new byte[2000000];
            this.rnd.nextBytes(data);
            TransientBlobKey key = (TransientBlobKey)BlobServerPutTest.put((BlobService)server, jobId, data, BlobKey.BlobType.TRANSIENT_BLOB);
            Assert.assertNotNull((Object)key);
            File blobFile = server.getStorageLocation(jobId, (BlobKey)key);
            Assert.assertTrue((boolean)blobFile.delete());
            Assert.assertTrue((boolean)BlobServerDeleteTest.delete((BlobService)cache, jobId, key));
            BlobServerGetTest.verifyDeleted((BlobService)cache, jobId, (BlobKey)key);
            Assert.assertTrue((boolean)BlobServerDeleteTest.delete((BlobService)cache, jobId, key));
            BlobServerGetTest.verifyDeleted((BlobService)cache, jobId, (BlobKey)key);
        }
    }

    @Test
    public void testDeleteTransientLocalFailsNoJob() throws IOException, InterruptedException {
        this.testDeleteTransientLocalFails(null);
    }

    @Test
    public void testDeleteTransientLocalFailsForJob() throws IOException, InterruptedException {
        this.testDeleteTransientLocalFails(new JobID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDeleteTransientLocalFails(@Nullable JobID jobId) throws IOException, InterruptedException {
        Assume.assumeTrue((!OperatingSystem.isWindows() ? 1 : 0) != 0);
        Configuration config = new Configuration();
        config.setString(BlobServerOptions.STORAGE_DIRECTORY, this.temporaryFolder.newFolder().getAbsolutePath());
        File blobFile = null;
        File directory = null;
        try (BlobServer server = new BlobServer(config, (BlobStore)new VoidBlobStore());
             BlobCacheService cache = new BlobCacheService(config, (BlobView)new VoidBlobStore(), new InetSocketAddress("localhost", server.getPort()));){
            server.start();
            try {
                byte[] data = new byte[2000000];
                this.rnd.nextBytes(data);
                TransientBlobKey key = (TransientBlobKey)BlobServerPutTest.put((BlobService)server, jobId, data, BlobKey.BlobType.TRANSIENT_BLOB);
                Assert.assertNotNull((Object)key);
                BlobServerPutTest.verifyContents((BlobService)cache, jobId, (BlobKey)key, data);
                blobFile = cache.getTransientBlobService().getStorageLocation(jobId, (BlobKey)key);
                directory = blobFile.getParentFile();
                Assert.assertTrue((boolean)blobFile.setWritable(false, false));
                Assert.assertTrue((boolean)directory.setWritable(false, false));
                Assert.assertFalse((boolean)BlobServerDeleteTest.delete((BlobService)cache, jobId, key));
                BlobServerPutTest.verifyContents((BlobService)cache, jobId, (BlobKey)key, data);
                BlobCachePutTest.verifyDeletedEventually(server, jobId, new BlobKey[]{key});
            }
            finally {
                if (blobFile != null && directory != null) {
                    blobFile.setWritable(true, false);
                    directory.setWritable(true, false);
                }
            }
        }
    }

    @Test
    public void testConcurrentDeleteOperationsNoJobTransient() throws IOException, ExecutionException, InterruptedException {
        this.testConcurrentDeleteOperations(null);
    }

    @Test
    public void testConcurrentDeleteOperationsForJobTransient() throws IOException, ExecutionException, InterruptedException {
        this.testConcurrentDeleteOperations(new JobID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testConcurrentDeleteOperations(@Nullable JobID jobId) throws IOException, InterruptedException, ExecutionException {
        Configuration config = new Configuration();
        config.setString(BlobServerOptions.STORAGE_DIRECTORY, this.temporaryFolder.newFolder().getAbsolutePath());
        int concurrentDeleteOperations = 3;
        ExecutorService executor = Executors.newFixedThreadPool(3);
        ArrayList<CompletableFuture<Void>> deleteFutures = new ArrayList<CompletableFuture<Void>>(3);
        byte[] data = new byte[]{1, 2, 3};
        try (BlobServer server = new BlobServer(config, (BlobStore)new VoidBlobStore());
             BlobCacheService cache = new BlobCacheService(config, (BlobView)new VoidBlobStore(), new InetSocketAddress("localhost", server.getPort()));){
            server.start();
            TransientBlobKey blobKey = (TransientBlobKey)BlobServerPutTest.put((BlobService)server, jobId, data, BlobKey.BlobType.TRANSIENT_BLOB);
            Assert.assertTrue((boolean)server.getStorageLocation(jobId, (BlobKey)blobKey).exists());
            for (int i = 0; i < 3; ++i) {
                CompletableFuture<Void> deleteFuture = CompletableFuture.supplyAsync(() -> {
                    try {
                        Assert.assertTrue((boolean)BlobServerDeleteTest.delete((BlobService)cache, jobId, blobKey));
                        Assert.assertFalse((boolean)cache.getTransientBlobService().getStorageLocation(jobId, (BlobKey)blobKey).exists());
                        Assert.assertTrue((boolean)server.getStorageLocation(jobId, (BlobKey)blobKey).exists());
                        return null;
                    }
                    catch (IOException e) {
                        throw new CompletionException((Throwable)new FlinkException("Could not upload blob.", (Throwable)e));
                    }
                }, executor);
                deleteFutures.add(deleteFuture);
            }
            FutureUtils.ConjunctFuture waitFuture = FutureUtils.waitForAll(deleteFutures);
            waitFuture.get();
            Assert.assertTrue((boolean)server.getStorageLocation(jobId, (BlobKey)blobKey).exists());
        }
        finally {
            executor.shutdownNow();
        }
    }
}

