/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.channel;

import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.runtime.checkpoint.channel.CheckpointInProgressRequest;
import org.junit.Assert;
import org.junit.Test;

public class CheckpointInProgressRequestTest {
    @Test
    public void testNoCancelTwice() throws Exception {
        int i;
        AtomicInteger counter = new AtomicInteger();
        CyclicBarrier barrier = new CyclicBarrier(10);
        CheckpointInProgressRequest request = this.cancelCountingRequest(counter, barrier);
        Thread[] threads = new Thread[barrier.getParties()];
        for (i = 0; i < barrier.getParties(); ++i) {
            threads[i] = new Thread(() -> {
                try {
                    request.cancel((Throwable)new RuntimeException("test"));
                }
                catch (Exception e) {
                    Assert.fail((String)e.getMessage());
                }
                this.await(barrier);
            });
        }
        for (i = 0; i < barrier.getParties(); ++i) {
            threads[i].start();
            threads[i].join();
        }
        Assert.assertEquals((long)1L, (long)counter.get());
    }

    private CheckpointInProgressRequest cancelCountingRequest(AtomicInteger cancelCounter, CyclicBarrier cb) {
        return new CheckpointInProgressRequest("test", 1L, unused -> {}, unused -> {
            cancelCounter.incrementAndGet();
            this.await(cb);
        }, false);
    }

    private void await(CyclicBarrier cb) {
        if (cb.getNumberWaiting() == 0) {
            return;
        }
        try {
            cb.await();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

