/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework.overlays;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.clusterframework.ContainerSpecification;
import org.junit.After;
import org.junit.Before;

public class ContainerOverlayTestBase {
    private Map<String, String> originalEnvironment;

    @Before
    public void before() {
        this.originalEnvironment = new HashMap<String, String>(System.getenv());
    }

    @After
    public void after() {
        CommonTestUtils.setEnv(this.originalEnvironment, (boolean)true);
    }

    protected static Path[] createPaths(File root, String ... paths) throws Exception {
        Path[] files = new Path[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            File file = root.toPath().resolve(paths[i]).toFile();
            file.getParentFile().mkdirs();
            file.createNewFile();
            files[i] = new Path(paths[i]);
        }
        return files;
    }

    protected static ContainerSpecification.Artifact checkArtifact(ContainerSpecification spec, Path remotePath) {
        for (ContainerSpecification.Artifact artifact : spec.getArtifacts()) {
            if (!remotePath.equals((Object)artifact.dest)) continue;
            return artifact;
        }
        throw new AssertionError((Object)("no such artifact (" + remotePath + ")"));
    }
}

