/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework.types;

import org.apache.flink.configuration.MemorySize;
import org.apache.flink.runtime.clusterframework.types.ResourceBudgetManager;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class ResourceBudgetManagerTest {
    @Test
    public void testReserve() {
        ResourceBudgetManager budgetManager = new ResourceBudgetManager(ResourceBudgetManagerTest.createResourceProfile(1.0, 100));
        Assert.assertThat((Object)budgetManager.reserve(ResourceBudgetManagerTest.createResourceProfile(0.7, 70)), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)budgetManager.getAvailableBudget(), (Matcher)Is.is((Object)ResourceBudgetManagerTest.createResourceProfile(0.3, 30)));
    }

    @Test
    public void testReserveFail() {
        ResourceBudgetManager budgetManager = new ResourceBudgetManager(ResourceBudgetManagerTest.createResourceProfile(1.0, 100));
        Assert.assertThat((Object)budgetManager.reserve(ResourceBudgetManagerTest.createResourceProfile(1.2, 120)), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)budgetManager.getAvailableBudget(), (Matcher)Is.is((Object)ResourceBudgetManagerTest.createResourceProfile(1.0, 100)));
    }

    @Test
    public void testRelease() {
        ResourceBudgetManager budgetManager = new ResourceBudgetManager(ResourceBudgetManagerTest.createResourceProfile(1.0, 100));
        Assert.assertThat((Object)budgetManager.reserve(ResourceBudgetManagerTest.createResourceProfile(0.7, 70)), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)budgetManager.release(ResourceBudgetManagerTest.createResourceProfile(0.5, 50)), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)budgetManager.getAvailableBudget(), (Matcher)Is.is((Object)ResourceBudgetManagerTest.createResourceProfile(0.8, 80)));
    }

    @Test
    public void testReleaseFail() {
        ResourceBudgetManager budgetManager = new ResourceBudgetManager(ResourceBudgetManagerTest.createResourceProfile(1.0, 100));
        Assert.assertThat((Object)budgetManager.reserve(ResourceBudgetManagerTest.createResourceProfile(0.7, 70)), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)budgetManager.release(ResourceBudgetManagerTest.createResourceProfile(0.8, 80)), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)budgetManager.getAvailableBudget(), (Matcher)Is.is((Object)ResourceBudgetManagerTest.createResourceProfile(0.3, 30)));
    }

    private static ResourceProfile createResourceProfile(double cpus, int memory) {
        return ResourceProfile.newBuilder().setCpuCores(cpus).setTaskHeapMemory(MemorySize.ofMebiBytes((long)memory)).build();
    }
}

