/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.failover.flip1.partitionrelease;

import java.util.Collections;
import org.apache.flink.runtime.executiongraph.failover.flip1.partitionrelease.ConsumerRegionGroupExecutionView;
import org.apache.flink.runtime.executiongraph.failover.flip1.partitionrelease.ConsumerRegionGroupExecutionViewMaintainer;
import org.apache.flink.runtime.scheduler.strategy.SchedulingPipelinedRegion;
import org.apache.flink.runtime.scheduler.strategy.TestingSchedulingExecutionVertex;
import org.apache.flink.runtime.scheduler.strategy.TestingSchedulingPipelinedRegion;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConsumerRegionGroupExecutionViewMaintainerTest
extends TestLogger {
    private TestingSchedulingPipelinedRegion producerRegion;
    private TestingSchedulingPipelinedRegion consumerRegion;
    private ConsumerRegionGroupExecutionView consumerRegionGroupExecutionView;
    private ConsumerRegionGroupExecutionViewMaintainer consumerRegionGroupExecutionViewMaintainer;

    @Before
    public void setup() {
        this.createProducerAndConsumer();
        this.createConsumerRegionGroupExecutionViewMaintainer();
    }

    @Test
    public void testRegionFinished() throws Exception {
        this.consumerRegionGroupExecutionViewMaintainer.regionFinished((SchedulingPipelinedRegion)this.consumerRegion);
        Assert.assertTrue((boolean)this.consumerRegionGroupExecutionView.isFinished());
    }

    @Test
    public void testRegionUnfinished() throws Exception {
        this.consumerRegionGroupExecutionViewMaintainer.regionFinished((SchedulingPipelinedRegion)this.consumerRegion);
        this.consumerRegionGroupExecutionViewMaintainer.regionUnfinished((SchedulingPipelinedRegion)this.consumerRegion);
        Assert.assertFalse((boolean)this.consumerRegionGroupExecutionView.isFinished());
    }

    @Test
    public void testRegionFinishedMultipleTimes() throws Exception {
        this.consumerRegionGroupExecutionViewMaintainer.regionFinished((SchedulingPipelinedRegion)this.consumerRegion);
        this.consumerRegionGroupExecutionViewMaintainer.regionFinished((SchedulingPipelinedRegion)this.consumerRegion);
        Assert.assertTrue((boolean)this.consumerRegionGroupExecutionView.isFinished());
    }

    @Test
    public void testRegionUnfinishedMultipleTimes() throws Exception {
        this.consumerRegionGroupExecutionViewMaintainer.regionUnfinished((SchedulingPipelinedRegion)this.consumerRegion);
        this.consumerRegionGroupExecutionViewMaintainer.regionUnfinished((SchedulingPipelinedRegion)this.consumerRegion);
        Assert.assertFalse((boolean)this.consumerRegionGroupExecutionView.isFinished());
        this.consumerRegionGroupExecutionViewMaintainer.regionFinished((SchedulingPipelinedRegion)this.consumerRegion);
        Assert.assertTrue((boolean)this.consumerRegionGroupExecutionView.isFinished());
    }

    @Test
    public void testFinishWrongRegion() {
        this.consumerRegionGroupExecutionViewMaintainer.regionFinished((SchedulingPipelinedRegion)this.producerRegion);
        Assert.assertFalse((boolean)this.consumerRegionGroupExecutionView.isFinished());
    }

    @Test
    public void testUnfinishedWrongRegion() {
        this.consumerRegionGroupExecutionViewMaintainer.regionUnfinished((SchedulingPipelinedRegion)this.producerRegion);
        Assert.assertFalse((boolean)this.consumerRegionGroupExecutionView.isFinished());
    }

    private void createProducerAndConsumer() {
        TestingSchedulingExecutionVertex producer = TestingSchedulingExecutionVertex.newBuilder().build();
        TestingSchedulingExecutionVertex consumer = TestingSchedulingExecutionVertex.newBuilder().build();
        this.producerRegion = new TestingSchedulingPipelinedRegion(Collections.singleton(producer));
        this.consumerRegion = new TestingSchedulingPipelinedRegion(Collections.singleton(consumer));
    }

    private void createConsumerRegionGroupExecutionViewMaintainer() {
        this.consumerRegionGroupExecutionView = new ConsumerRegionGroupExecutionView();
        this.consumerRegionGroupExecutionView.add((SchedulingPipelinedRegion)this.consumerRegion);
        this.consumerRegionGroupExecutionViewMaintainer = new ConsumerRegionGroupExecutionViewMaintainer(Collections.singletonList(this.consumerRegionGroupExecutionView));
    }
}

