/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.writer;

import org.apache.flink.runtime.checkpoint.InflightDataRescalingDescriptorUtil;
import org.apache.flink.runtime.io.network.api.writer.SubtaskStateMapper;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ErrorCollector;

public class SubtaskStateMapperTest {
    @Rule
    public ErrorCollector collector = new ErrorCollector();

    @Test
    public void testFirstTaskMappingOnScaleDown() {
        Assert.assertEquals((Object)InflightDataRescalingDescriptorUtil.mappings(InflightDataRescalingDescriptorUtil.to(0, 1, 2), InflightDataRescalingDescriptorUtil.to(new int[0])), (Object)SubtaskStateMapper.FIRST.getNewToOldSubtasksMapping(3, 2));
    }

    @Test
    public void testFirstTaskMappingOnNoScale() {
        Assert.assertEquals((Object)InflightDataRescalingDescriptorUtil.mappings(InflightDataRescalingDescriptorUtil.to(0, 1, 2), InflightDataRescalingDescriptorUtil.to(new int[0]), InflightDataRescalingDescriptorUtil.to(new int[0])), (Object)SubtaskStateMapper.FIRST.getNewToOldSubtasksMapping(3, 3));
    }

    @Test
    public void testFirstTaskMappingOnScaleUp() {
        Assert.assertEquals((Object)InflightDataRescalingDescriptorUtil.mappings(InflightDataRescalingDescriptorUtil.to(0, 1, 2), InflightDataRescalingDescriptorUtil.to(new int[0]), InflightDataRescalingDescriptorUtil.to(new int[0]), InflightDataRescalingDescriptorUtil.to(new int[0])), (Object)SubtaskStateMapper.FIRST.getNewToOldSubtasksMapping(3, 4));
    }

    @Test
    public void testFullTaskMappingOnScaleDown() {
        Assert.assertEquals((Object)InflightDataRescalingDescriptorUtil.mappings(InflightDataRescalingDescriptorUtil.to(0, 1, 2), InflightDataRescalingDescriptorUtil.to(0, 1, 2)), (Object)SubtaskStateMapper.FULL.getNewToOldSubtasksMapping(3, 2));
    }

    @Test
    public void testFullTaskMappingOnNoScale() {
        Assert.assertEquals((Object)InflightDataRescalingDescriptorUtil.mappings(InflightDataRescalingDescriptorUtil.to(0, 1, 2), InflightDataRescalingDescriptorUtil.to(0, 1, 2), InflightDataRescalingDescriptorUtil.to(0, 1, 2)), (Object)SubtaskStateMapper.FULL.getNewToOldSubtasksMapping(3, 3));
    }

    @Test
    public void testFullTaskMappingOnScaleUp() {
        Assert.assertEquals((Object)InflightDataRescalingDescriptorUtil.mappings(InflightDataRescalingDescriptorUtil.to(0, 1, 2), InflightDataRescalingDescriptorUtil.to(0, 1, 2), InflightDataRescalingDescriptorUtil.to(0, 1, 2), InflightDataRescalingDescriptorUtil.to(0, 1, 2)), (Object)SubtaskStateMapper.FULL.getNewToOldSubtasksMapping(3, 4));
    }

    @Test
    public void testRangeSelectorTaskMappingOnScaleDown() {
        Assert.assertEquals((Object)InflightDataRescalingDescriptorUtil.mappings(InflightDataRescalingDescriptorUtil.to(0, 1), InflightDataRescalingDescriptorUtil.to(1, 2)), (Object)SubtaskStateMapper.RANGE.getNewToOldSubtasksMapping(3, 2));
        Assert.assertEquals((Object)InflightDataRescalingDescriptorUtil.mappings(InflightDataRescalingDescriptorUtil.to(0, 1, 2, 3, 4), InflightDataRescalingDescriptorUtil.to(5, 6, 7, 8, 9)), (Object)SubtaskStateMapper.RANGE.getNewToOldSubtasksMapping(10, 2));
        Assert.assertEquals((Object)InflightDataRescalingDescriptorUtil.mappings(new int[][]{InflightDataRescalingDescriptorUtil.to(0, 1, 2, 3, 4, 5, 6, 7, 8, 9)}), (Object)SubtaskStateMapper.RANGE.getNewToOldSubtasksMapping(10, 1));
    }

    @Test
    public void testRangeSelectorTaskMappingOnNoScale() {
        Assert.assertEquals((Object)InflightDataRescalingDescriptorUtil.mappings(InflightDataRescalingDescriptorUtil.to(0), InflightDataRescalingDescriptorUtil.to(1), InflightDataRescalingDescriptorUtil.to(2)), (Object)SubtaskStateMapper.RANGE.getNewToOldSubtasksMapping(3, 3));
    }

    @Test
    public void testRangeSelectorTaskMappingOnScaleUp() {
        Assert.assertEquals((Object)InflightDataRescalingDescriptorUtil.mappings(InflightDataRescalingDescriptorUtil.to(0), InflightDataRescalingDescriptorUtil.to(0, 1), InflightDataRescalingDescriptorUtil.to(1, 2), InflightDataRescalingDescriptorUtil.to(2)), (Object)SubtaskStateMapper.RANGE.getNewToOldSubtasksMapping(3, 4));
        Assert.assertEquals((Object)InflightDataRescalingDescriptorUtil.mappings(InflightDataRescalingDescriptorUtil.to(0), InflightDataRescalingDescriptorUtil.to(0), InflightDataRescalingDescriptorUtil.to(0, 1), InflightDataRescalingDescriptorUtil.to(1), InflightDataRescalingDescriptorUtil.to(1, 2), InflightDataRescalingDescriptorUtil.to(2), InflightDataRescalingDescriptorUtil.to(2)), (Object)SubtaskStateMapper.RANGE.getNewToOldSubtasksMapping(3, 7));
    }

    @Test
    public void testRoundRobinTaskMappingOnScaleDown() {
        Assert.assertEquals((Object)InflightDataRescalingDescriptorUtil.mappings(InflightDataRescalingDescriptorUtil.to(0, 4, 8), InflightDataRescalingDescriptorUtil.to(1, 5, 9), InflightDataRescalingDescriptorUtil.to(2, 6), InflightDataRescalingDescriptorUtil.to(3, 7)), (Object)SubtaskStateMapper.ROUND_ROBIN.getNewToOldSubtasksMapping(10, 4));
        Assert.assertEquals((Object)InflightDataRescalingDescriptorUtil.mappings(InflightDataRescalingDescriptorUtil.to(0, 4), InflightDataRescalingDescriptorUtil.to(1), InflightDataRescalingDescriptorUtil.to(2), InflightDataRescalingDescriptorUtil.to(3)), (Object)SubtaskStateMapper.ROUND_ROBIN.getNewToOldSubtasksMapping(5, 4));
        Assert.assertEquals((Object)InflightDataRescalingDescriptorUtil.mappings(InflightDataRescalingDescriptorUtil.to(0, 2, 4), InflightDataRescalingDescriptorUtil.to(1, 3)), (Object)SubtaskStateMapper.ROUND_ROBIN.getNewToOldSubtasksMapping(5, 2));
        Assert.assertEquals((Object)InflightDataRescalingDescriptorUtil.mappings(new int[][]{InflightDataRescalingDescriptorUtil.to(0, 1, 2, 3, 4)}), (Object)SubtaskStateMapper.ROUND_ROBIN.getNewToOldSubtasksMapping(5, 1));
    }

    @Test
    public void testRoundRobinTaskMappingOnNoScale() {
        Assert.assertEquals((Object)InflightDataRescalingDescriptorUtil.mappings(InflightDataRescalingDescriptorUtil.to(0), InflightDataRescalingDescriptorUtil.to(1), InflightDataRescalingDescriptorUtil.to(2), InflightDataRescalingDescriptorUtil.to(3), InflightDataRescalingDescriptorUtil.to(4), InflightDataRescalingDescriptorUtil.to(5), InflightDataRescalingDescriptorUtil.to(6), InflightDataRescalingDescriptorUtil.to(7), InflightDataRescalingDescriptorUtil.to(8), InflightDataRescalingDescriptorUtil.to(9)), (Object)SubtaskStateMapper.ROUND_ROBIN.getNewToOldSubtasksMapping(10, 10));
        Assert.assertEquals((Object)InflightDataRescalingDescriptorUtil.mappings(InflightDataRescalingDescriptorUtil.to(0), InflightDataRescalingDescriptorUtil.to(1), InflightDataRescalingDescriptorUtil.to(2), InflightDataRescalingDescriptorUtil.to(3), InflightDataRescalingDescriptorUtil.to(4)), (Object)SubtaskStateMapper.ROUND_ROBIN.getNewToOldSubtasksMapping(5, 5));
        Assert.assertEquals((Object)InflightDataRescalingDescriptorUtil.mappings(new int[][]{InflightDataRescalingDescriptorUtil.to(0)}), (Object)SubtaskStateMapper.ROUND_ROBIN.getNewToOldSubtasksMapping(1, 1));
    }

    @Test
    public void testRoundRobinTaskMappingOnScaleUp() {
        Assert.assertEquals((Object)InflightDataRescalingDescriptorUtil.mappings(InflightDataRescalingDescriptorUtil.to(0), InflightDataRescalingDescriptorUtil.to(1), InflightDataRescalingDescriptorUtil.to(2), InflightDataRescalingDescriptorUtil.to(3), InflightDataRescalingDescriptorUtil.to(new int[0]), InflightDataRescalingDescriptorUtil.to(new int[0]), InflightDataRescalingDescriptorUtil.to(new int[0]), InflightDataRescalingDescriptorUtil.to(new int[0]), InflightDataRescalingDescriptorUtil.to(new int[0]), InflightDataRescalingDescriptorUtil.to(new int[0])), (Object)SubtaskStateMapper.ROUND_ROBIN.getNewToOldSubtasksMapping(4, 10));
        Assert.assertEquals((Object)InflightDataRescalingDescriptorUtil.mappings(InflightDataRescalingDescriptorUtil.to(0), InflightDataRescalingDescriptorUtil.to(1), InflightDataRescalingDescriptorUtil.to(2), InflightDataRescalingDescriptorUtil.to(3), InflightDataRescalingDescriptorUtil.to(new int[0])), (Object)SubtaskStateMapper.ROUND_ROBIN.getNewToOldSubtasksMapping(4, 5));
        Assert.assertEquals((Object)InflightDataRescalingDescriptorUtil.mappings(InflightDataRescalingDescriptorUtil.to(0), InflightDataRescalingDescriptorUtil.to(1), InflightDataRescalingDescriptorUtil.to(new int[0]), InflightDataRescalingDescriptorUtil.to(new int[0]), InflightDataRescalingDescriptorUtil.to(new int[0])), (Object)SubtaskStateMapper.ROUND_ROBIN.getNewToOldSubtasksMapping(2, 5));
        Assert.assertEquals((Object)InflightDataRescalingDescriptorUtil.mappings(InflightDataRescalingDescriptorUtil.to(0), InflightDataRescalingDescriptorUtil.to(new int[0]), InflightDataRescalingDescriptorUtil.to(new int[0]), InflightDataRescalingDescriptorUtil.to(new int[0]), InflightDataRescalingDescriptorUtil.to(new int[0])), (Object)SubtaskStateMapper.ROUND_ROBIN.getNewToOldSubtasksMapping(1, 5));
    }
}

