/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import java.io.IOException;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.RecoveredInputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGateBuilder;
import org.apache.flink.runtime.state.CheckpointStorageLocationReference;
import org.junit.Test;

public class RecoveredInputChannelTest {
    @Test(expected=IllegalStateException.class)
    public void testConversionOnlyPossibleAfterConsumed() throws IOException {
        this.buildChannel().toInputChannel();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRequestPartitionsImpossible() {
        this.buildChannel().requestSubpartition(0);
    }

    @Test(expected=CheckpointException.class)
    public void testCheckpointStartImpossible() throws CheckpointException {
        this.buildChannel().checkpointStarted(new CheckpointBarrier(0L, 0L, CheckpointOptions.unaligned((CheckpointStorageLocationReference)CheckpointStorageLocationReference.getDefault())));
    }

    private RecoveredInputChannel buildChannel() {
        try {
            return new RecoveredInputChannel(new SingleInputGateBuilder().build(), 0, new ResultPartitionID(), 0, 0, (Counter)new SimpleCounter(), (Counter)new SimpleCounter(), 10){

                protected InputChannel toInputChannelInternal() {
                    throw new AssertionError((Object)"channel conversion succeeded");
                }
            };
        }
        catch (Exception e) {
            throw new AssertionError("channel creation failed", e);
        }
    }
}

