/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.Collection;
import java.util.function.Consumer;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.jobmaster.slotpool.AllocatedSlotPool;
import org.apache.flink.runtime.jobmaster.slotpool.DefaultAllocatedSlotPool;
import org.apache.flink.runtime.jobmaster.slotpool.DefaultDeclarativeSlotPool;
import org.apache.flink.runtime.slots.ResourceRequirement;

final class DefaultDeclarativeSlotPoolBuilder {
    private AllocatedSlotPool allocatedSlotPool = new DefaultAllocatedSlotPool();
    private Consumer<? super Collection<ResourceRequirement>> notifyNewResourceRequirements = ignored -> {};
    private Time idleSlotTimeout = Time.seconds((long)20L);
    private Time rpcTimeout = Time.seconds((long)20L);

    DefaultDeclarativeSlotPoolBuilder() {
    }

    public DefaultDeclarativeSlotPoolBuilder setAllocatedSlotPool(AllocatedSlotPool allocatedSlotPool) {
        this.allocatedSlotPool = allocatedSlotPool;
        return this;
    }

    public DefaultDeclarativeSlotPoolBuilder setNotifyNewResourceRequirements(Consumer<? super Collection<ResourceRequirement>> notifyNewResourceRequirements) {
        this.notifyNewResourceRequirements = notifyNewResourceRequirements;
        return this;
    }

    public DefaultDeclarativeSlotPoolBuilder setIdleSlotTimeout(Time idleSlotTimeout) {
        this.idleSlotTimeout = idleSlotTimeout;
        return this;
    }

    public DefaultDeclarativeSlotPool build() {
        return new DefaultDeclarativeSlotPool(new JobID(), this.allocatedSlotPool, this.notifyNewResourceRequirements, this.idleSlotTimeout, this.rpcTimeout);
    }

    public static DefaultDeclarativeSlotPoolBuilder builder() {
        return new DefaultDeclarativeSlotPoolBuilder();
    }
}

