/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.jobmaster.JobMasterId;
import org.apache.flink.runtime.jobmaster.slotpool.TestingSlotPoolImpl;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.resourcemanager.utils.TestingResourceManagerGateway;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.SystemClock;

public class SlotPoolBuilder {
    private final ComponentMainThreadExecutor componentMainThreadExecutor;
    private JobID jobId = new JobID();
    private Time batchSlotTimeout = Time.milliseconds((long)((Long)JobManagerOptions.SLOT_IDLE_TIMEOUT.defaultValue()));
    private Time idleSlotTimeout = TestingUtils.infiniteTime();
    private Clock clock = SystemClock.getInstance();
    @Nullable
    private ResourceManagerGateway resourceManagerGateway = new TestingResourceManagerGateway();

    public SlotPoolBuilder(ComponentMainThreadExecutor componentMainThreadExecutor) {
        this.componentMainThreadExecutor = componentMainThreadExecutor;
    }

    public SlotPoolBuilder setResourceManagerGateway(@Nullable ResourceManagerGateway resourceManagerGateway) {
        this.resourceManagerGateway = resourceManagerGateway;
        return this;
    }

    public SlotPoolBuilder setBatchSlotTimeout(Time batchSlotTimeout) {
        this.batchSlotTimeout = batchSlotTimeout;
        return this;
    }

    public SlotPoolBuilder setIdleSlotTimeout(Time idleSlotTimeout) {
        this.idleSlotTimeout = idleSlotTimeout;
        return this;
    }

    public SlotPoolBuilder setClock(Clock clock) {
        this.clock = clock;
        return this;
    }

    public SlotPoolBuilder setJobId(JobID jobId) {
        this.jobId = jobId;
        return this;
    }

    public TestingSlotPoolImpl build() throws Exception {
        TestingSlotPoolImpl slotPool = new TestingSlotPoolImpl(this.jobId, this.clock, TestingUtils.infiniteTime(), this.idleSlotTimeout, this.batchSlotTimeout);
        slotPool.start(JobMasterId.generate(), "foobar", this.componentMainThreadExecutor);
        if (this.resourceManagerGateway != null) {
            CompletableFuture.runAsync(() -> slotPool.connectToResourceManager(this.resourceManagerGateway), (Executor)this.componentMainThreadExecutor).join();
        }
        return slotPool;
    }
}

