/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderelection;

import java.time.Duration;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.flink.api.common.time.Deadline;
import org.apache.flink.runtime.leaderelection.LeaderInformation;
import org.apache.flink.runtime.testutils.CommonTestUtils;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.function.SupplierWithException;

public class TestingLeaderBase {
    protected final BlockingQueue<LeaderInformation> leaderEventQueue = new LinkedBlockingQueue<LeaderInformation>();
    private final BlockingQueue<Throwable> errorQueue = new LinkedBlockingQueue<Throwable>();
    private boolean isLeader = false;
    private Throwable error;

    public void waitForLeader(long timeout) throws Exception {
        this.throwExceptionIfNotNull();
        String errorMsg = "Contender was not elected as the leader within " + timeout + "ms";
        CommonTestUtils.waitUntilCondition((SupplierWithException<Boolean, Exception>)((SupplierWithException)() -> {
            LeaderInformation leader = this.leaderEventQueue.poll(timeout, TimeUnit.MILLISECONDS);
            return leader != null && !leader.isEmpty();
        }), Deadline.fromNow((Duration)Duration.ofMillis(timeout)), errorMsg);
        this.isLeader = true;
    }

    public void waitForRevokeLeader(long timeout) throws Exception {
        this.throwExceptionIfNotNull();
        String errorMsg = "Contender was not revoked within " + timeout + "ms";
        CommonTestUtils.waitUntilCondition((SupplierWithException<Boolean, Exception>)((SupplierWithException)() -> {
            LeaderInformation leader = this.leaderEventQueue.poll(timeout, TimeUnit.MILLISECONDS);
            return leader != null && leader.isEmpty();
        }), Deadline.fromNow((Duration)Duration.ofMillis(timeout)), errorMsg);
        this.isLeader = false;
    }

    public void waitForError(long timeout) throws Exception {
        String errorMsg = "Contender did not see an exception with " + timeout + "ms";
        CommonTestUtils.waitUntilCondition((SupplierWithException<Boolean, Exception>)((SupplierWithException)() -> {
            this.error = this.errorQueue.poll(timeout, TimeUnit.MILLISECONDS);
            return this.error != null;
        }), Deadline.fromNow((Duration)Duration.ofMillis(timeout)), errorMsg);
    }

    public void handleError(Throwable ex) {
        this.errorQueue.offer(ex);
    }

    @Nullable
    public Throwable getError() {
        return this.error;
    }

    public boolean isLeader() {
        return this.isLeader;
    }

    private void throwExceptionIfNotNull() throws Exception {
        if (this.error != null) {
            ExceptionUtils.rethrowException((Throwable)this.error);
        }
    }
}

