/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.coordination.util;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.flink.runtime.operators.coordination.util.IncompleteFuturesTracker;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class IncompleteFuturesTrackerTest {
    @Test
    public void testFutureTracked() {
        IncompleteFuturesTracker tracker = new IncompleteFuturesTracker();
        CompletableFuture future = new CompletableFuture();
        tracker.trackFutureWhileIncomplete(future);
        Assert.assertThat((Object)tracker.getCurrentIncompleteAndReset(), (Matcher)Matchers.contains((Object[])new CompletableFuture[]{future}));
    }

    @Test
    public void testFutureRemovedAfterCompletion() {
        IncompleteFuturesTracker tracker = new IncompleteFuturesTracker();
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        tracker.trackFutureWhileIncomplete(future);
        future.complete(null);
        Assert.assertThat((Object)tracker.getCurrentIncompleteAndReset(), (Matcher)Matchers.not((Matcher)Matchers.contains((Object[])new CompletableFuture[]{future})));
    }

    @Test
    public void testFutureNotAddedIfAlreadyCompleted() {
        IncompleteFuturesTracker tracker = new IncompleteFuturesTracker();
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        future.complete(null);
        tracker.trackFutureWhileIncomplete(future);
        Assert.assertThat((Object)tracker.getCurrentIncompleteAndReset(), (Matcher)Matchers.not((Matcher)Matchers.contains((Object[])new CompletableFuture[]{future})));
    }

    @Test
    public void testFailFutures() throws Exception {
        IncompleteFuturesTracker tracker = new IncompleteFuturesTracker();
        CompletableFuture future = new CompletableFuture();
        tracker.trackFutureWhileIncomplete(future);
        Exception expectedException = new Exception();
        tracker.failAllFutures((Throwable)expectedException);
        Assert.assertTrue((boolean)future.isCompletedExceptionally());
        try {
            future.get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertSame((Object)expectedException, (Object)e.getCause());
        }
    }

    @Test
    public void testFailFuturesImmediately() throws Exception {
        IncompleteFuturesTracker tracker = new IncompleteFuturesTracker();
        CompletableFuture future = new CompletableFuture();
        Exception expectedException = new Exception();
        tracker.failAllFutures((Throwable)expectedException);
        tracker.trackFutureWhileIncomplete(future);
        Assert.assertTrue((boolean)future.isCompletedExceptionally());
        try {
            future.get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertSame((Object)expectedException, (Object)e.getCause());
        }
    }

    @Test
    public void testResetClearsTrackedFutures() {
        IncompleteFuturesTracker tracker = new IncompleteFuturesTracker();
        CompletableFuture future = new CompletableFuture();
        tracker.trackFutureWhileIncomplete(future);
        tracker.getCurrentIncompleteAndReset();
        Assert.assertThat((Object)tracker.getCurrentIncompleteAndReset(), (Matcher)Matchers.empty());
    }
}

