/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.sort;

import java.util.List;
import java.util.Random;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeHint;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.runtime.TupleSerializer;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.memory.MemoryManagerBuilder;
import org.apache.flink.runtime.operators.sort.LargeRecordHandler;
import org.apache.flink.runtime.operators.testutils.DummyInvokable;
import org.apache.flink.util.MutableObjectIterator;
import org.junit.Assert;
import org.junit.Test;

public class LargeRecordHandlerTest {
    @Test
    public void testEmptyRecordHandler() {
        int PAGE_SIZE = 4096;
        int NUM_PAGES = 50;
        try (IOManagerAsync ioMan = new IOManagerAsync();){
            MemoryManager memMan = MemoryManagerBuilder.newBuilder().setMemorySize(204800L).setPageSize(4096).build();
            DummyInvokable owner = new DummyInvokable();
            List memory = memMan.allocatePages((Object)owner, 50);
            TupleTypeInfo typeInfo = (TupleTypeInfo)TypeInformation.of((TypeHint)new TypeHint<Tuple2<Long, String>>(){});
            TupleSerializer serializer = typeInfo.createSerializer(new ExecutionConfig());
            TypeComparator comparator = typeInfo.createComparator(new int[]{0}, new boolean[]{true}, 0, new ExecutionConfig());
            LargeRecordHandler handler = new LargeRecordHandler((TypeSerializer)serializer, comparator, (IOManager)ioMan, memMan, memory, (AbstractInvokable)owner, 128);
            Assert.assertFalse((boolean)handler.hasData());
            handler.close();
            Assert.assertFalse((boolean)handler.hasData());
            handler.close();
            try {
                handler.addRecord((Object)new Tuple2((Object)92L, (Object)"peter pepper"));
                Assert.fail((String)"should throw an exception");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            Assert.assertTrue((boolean)memMan.verifyEmpty());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testRecordHandlerSingleKey() {
        int PAGE_SIZE = 4096;
        int NUM_PAGES = 24;
        int NUM_RECORDS = 25000;
        try (IOManagerAsync ioMan = new IOManagerAsync();){
            Tuple2 next;
            MemoryManager memMan = MemoryManagerBuilder.newBuilder().setMemorySize(98304L).setPageSize(4096).build();
            DummyInvokable owner = new DummyInvokable();
            List initialMemory = memMan.allocatePages((Object)owner, 6);
            List sortMemory = memMan.allocatePages((Object)owner, 18);
            TupleTypeInfo typeInfo = (TupleTypeInfo)TypeInformation.of((TypeHint)new TypeHint<Tuple2<Long, String>>(){});
            TupleSerializer serializer = typeInfo.createSerializer(new ExecutionConfig());
            TypeComparator comparator = typeInfo.createComparator(new int[]{0}, new boolean[]{true}, 0, new ExecutionConfig());
            LargeRecordHandler handler = new LargeRecordHandler((TypeSerializer)serializer, comparator, (IOManager)ioMan, memMan, initialMemory, (AbstractInvokable)owner, 128);
            Assert.assertFalse((boolean)handler.hasData());
            Random rnd = new Random();
            for (int i = 0; i < 25000; ++i) {
                long val = rnd.nextLong();
                handler.addRecord((Object)new Tuple2((Object)val, (Object)String.valueOf(val)));
                Assert.assertTrue((boolean)handler.hasData());
            }
            MutableObjectIterator sorted = handler.finishWriteAndSortKeys(sortMemory);
            try {
                handler.addRecord((Object)new Tuple2((Object)92L, (Object)"peter pepper"));
                Assert.fail((String)"should throw an exception");
            }
            catch (IllegalStateException val) {
                // empty catch block
            }
            Tuple2 previous = null;
            while ((next = (Tuple2)sorted.next(null)) != null) {
                Assert.assertTrue((boolean)((Long)next.f0).equals(Long.parseLong((String)next.f1)));
                if (previous != null) {
                    Assert.assertTrue(((Long)previous.f0 <= (Long)next.f0 ? 1 : 0) != 0);
                }
                previous = next;
            }
            handler.close();
            Assert.assertFalse((boolean)handler.hasData());
            handler.close();
            try {
                handler.addRecord((Object)new Tuple2((Object)92L, (Object)"peter pepper"));
                Assert.fail((String)"should throw an exception");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            Assert.assertTrue((boolean)memMan.verifyEmpty());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testRecordHandlerCompositeKey() {
        int PAGE_SIZE = 4096;
        int NUM_PAGES = 24;
        int NUM_RECORDS = 25000;
        try (IOManagerAsync ioMan = new IOManagerAsync();){
            Tuple3 next;
            MemoryManager memMan = MemoryManagerBuilder.newBuilder().setMemorySize(98304L).setPageSize(4096).build();
            DummyInvokable owner = new DummyInvokable();
            List initialMemory = memMan.allocatePages((Object)owner, 6);
            List sortMemory = memMan.allocatePages((Object)owner, 18);
            TupleTypeInfo typeInfo = (TupleTypeInfo)TypeInformation.of((TypeHint)new TypeHint<Tuple3<Long, String, Byte>>(){});
            TupleSerializer serializer = typeInfo.createSerializer(new ExecutionConfig());
            TypeComparator comparator = typeInfo.createComparator(new int[]{2, 0}, new boolean[]{true, true}, 0, new ExecutionConfig());
            LargeRecordHandler handler = new LargeRecordHandler((TypeSerializer)serializer, comparator, (IOManager)ioMan, memMan, initialMemory, (AbstractInvokable)owner, 128);
            Assert.assertFalse((boolean)handler.hasData());
            Random rnd = new Random();
            for (int i = 0; i < 25000; ++i) {
                long val = rnd.nextLong();
                handler.addRecord((Object)new Tuple3((Object)val, (Object)String.valueOf(val), (Object)((byte)val)));
                Assert.assertTrue((boolean)handler.hasData());
            }
            MutableObjectIterator sorted = handler.finishWriteAndSortKeys(sortMemory);
            try {
                handler.addRecord((Object)new Tuple3((Object)92L, (Object)"peter pepper", (Object)1));
                Assert.fail((String)"should throw an exception");
            }
            catch (IllegalStateException val) {
                // empty catch block
            }
            Tuple3 previous = null;
            while ((next = (Tuple3)sorted.next(null)) != null) {
                Assert.assertTrue((boolean)((Long)next.f0).equals(Long.parseLong((String)next.f1)));
                Assert.assertTrue((((Long)next.f0).byteValue() == ((Byte)next.f2).byteValue() ? 1 : 0) != 0);
                if (previous != null) {
                    Assert.assertTrue(((Byte)previous.f2 <= (Byte)next.f2 ? 1 : 0) != 0);
                    Assert.assertTrue((((Byte)previous.f2).byteValue() != ((Byte)next.f2).byteValue() || (Long)previous.f0 <= (Long)next.f0 ? 1 : 0) != 0);
                }
                previous = next;
            }
            handler.close();
            Assert.assertFalse((boolean)handler.hasData());
            handler.close();
            try {
                handler.addRecord((Object)new Tuple3((Object)92L, (Object)"peter pepper", (Object)1));
                Assert.fail((String)"should throw an exception");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            Assert.assertTrue((boolean)memMan.verifyEmpty());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

