/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc.akka;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.runtime.rpc.akka.AkkaRpcSerializedValue;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class AkkaRpcSerializedValueTest
extends TestLogger {
    @Test
    public void testNullValue() throws Exception {
        AkkaRpcSerializedValue serializedValue = AkkaRpcSerializedValue.valueOf(null);
        Assert.assertThat((Object)serializedValue.getSerializedData(), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)serializedValue.getSerializedDataLength(), (Matcher)Matchers.equalTo((Object)0));
        Assert.assertThat((Object)serializedValue.deserializeValue(((Object)((Object)this)).getClass().getClassLoader()), (Matcher)Matchers.nullValue());
        AkkaRpcSerializedValue otherSerializedValue = AkkaRpcSerializedValue.valueOf(null);
        Assert.assertThat((Object)otherSerializedValue, (Matcher)Matchers.equalTo((Object)serializedValue));
        Assert.assertThat((Object)otherSerializedValue.hashCode(), (Matcher)Matchers.equalTo((Object)serializedValue.hashCode()));
        AkkaRpcSerializedValue clonedSerializedValue = (AkkaRpcSerializedValue)InstantiationUtil.clone((Serializable)serializedValue);
        Assert.assertThat((Object)clonedSerializedValue.getSerializedData(), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)clonedSerializedValue.getSerializedDataLength(), (Matcher)Matchers.equalTo((Object)0));
        Assert.assertThat((Object)clonedSerializedValue.deserializeValue(((Object)((Object)this)).getClass().getClassLoader()), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)clonedSerializedValue, (Matcher)Matchers.equalTo((Object)serializedValue));
        Assert.assertThat((Object)clonedSerializedValue.hashCode(), (Matcher)Matchers.equalTo((Object)serializedValue.hashCode()));
    }

    @Test
    public void testNotNullValues() throws Exception {
        Set values = Stream.of(Boolean.valueOf(true), (byte)5, (short)6, 5, 5L, Float.valueOf(5.5f), 6.5, Character.valueOf('c'), "string", Instant.now(), BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.TEN), BigDecimal.valueOf(Math.PI)).collect(Collectors.toSet());
        Object previousValue = null;
        AkkaRpcSerializedValue previousSerializedValue = null;
        for (Object value : values) {
            AkkaRpcSerializedValue serializedValue = AkkaRpcSerializedValue.valueOf(value);
            Assert.assertThat((String)value.toString(), (Object)serializedValue.getSerializedData(), (Matcher)Matchers.notNullValue());
            Assert.assertThat((String)value.toString(), (Object)serializedValue.getSerializedDataLength(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
            Assert.assertThat((String)value.toString(), (Object)serializedValue.deserializeValue(((Object)((Object)this)).getClass().getClassLoader()), (Matcher)Matchers.equalTo(value));
            AkkaRpcSerializedValue otherSerializedValue = AkkaRpcSerializedValue.valueOf(value);
            Assert.assertThat((String)value.toString(), (Object)otherSerializedValue, (Matcher)Matchers.equalTo((Object)serializedValue));
            Assert.assertThat((String)value.toString(), (Object)otherSerializedValue.hashCode(), (Matcher)Matchers.equalTo((Object)serializedValue.hashCode()));
            AkkaRpcSerializedValue clonedSerializedValue = (AkkaRpcSerializedValue)InstantiationUtil.clone((Serializable)serializedValue);
            Assert.assertThat((String)value.toString(), (Object)clonedSerializedValue.getSerializedData(), (Matcher)Matchers.equalTo((Object)serializedValue.getSerializedData()));
            Assert.assertThat((String)value.toString(), (Object)clonedSerializedValue.deserializeValue(((Object)((Object)this)).getClass().getClassLoader()), (Matcher)Matchers.equalTo(value));
            Assert.assertThat((String)value.toString(), (Object)clonedSerializedValue, (Matcher)Matchers.equalTo((Object)serializedValue));
            Assert.assertThat((String)value.toString(), (Object)clonedSerializedValue.hashCode(), (Matcher)Matchers.equalTo((Object)serializedValue.hashCode()));
            if (previousValue != null && !previousValue.equals(value)) {
                Assert.assertThat((String)(value.toString() + " " + previousValue.toString()), (Object)serializedValue, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)previousSerializedValue)));
            }
            previousValue = value;
            previousSerializedValue = serializedValue;
        }
    }
}

