/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.JobException;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.scheduler.ExecutionVertexOperations;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.util.Preconditions;

public class TestExecutionVertexOperationsDecorator
implements ExecutionVertexOperations {
    private final ExecutionVertexOperations delegate;
    private final List<ExecutionVertexID> deployedVertices = new ArrayList<ExecutionVertexID>();
    private boolean failDeploy;

    public TestExecutionVertexOperationsDecorator(ExecutionVertexOperations delegate) {
        this.delegate = (ExecutionVertexOperations)Preconditions.checkNotNull((Object)delegate);
    }

    public void deploy(ExecutionVertex executionVertex) throws JobException {
        this.deployedVertices.add(executionVertex.getID());
        if (this.failDeploy) {
            throw new RuntimeException("Expected");
        }
        this.delegate.deploy(executionVertex);
    }

    public CompletableFuture<?> cancel(ExecutionVertex executionVertex) {
        return this.delegate.cancel(executionVertex);
    }

    public void markFailed(ExecutionVertex executionVertex, Throwable cause) {
        this.delegate.markFailed(executionVertex, cause);
    }

    public void enableFailDeploy() {
        this.failDeploy = true;
    }

    public void disableFailDeploy() {
        this.failDeploy = false;
    }

    public List<ExecutionVertexID> getDeployedVertices() {
        return Collections.unmodifiableList(this.deployedVertices);
    }
}

