/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.benchmark;

import org.apache.flink.api.common.ExecutionMode;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.JobType;

public enum JobConfiguration {
    STREAMING(DistributionPattern.ALL_TO_ALL, ResultPartitionType.PIPELINED, JobType.STREAMING, ExecutionMode.PIPELINED, 4000),
    BATCH(DistributionPattern.ALL_TO_ALL, ResultPartitionType.BLOCKING, JobType.BATCH, ExecutionMode.BATCH, 4000),
    STREAMING_TEST(DistributionPattern.ALL_TO_ALL, ResultPartitionType.PIPELINED, JobType.STREAMING, ExecutionMode.PIPELINED, 10),
    BATCH_TEST(DistributionPattern.ALL_TO_ALL, ResultPartitionType.BLOCKING, JobType.BATCH, ExecutionMode.BATCH, 10);

    private final int parallelism;
    private final DistributionPattern distributionPattern;
    private final ResultPartitionType resultPartitionType;
    private final JobType jobType;
    private final ExecutionMode executionMode;

    private JobConfiguration(DistributionPattern distributionPattern, ResultPartitionType resultPartitionType, JobType jobType, ExecutionMode executionMode, int parallelism) {
        this.distributionPattern = distributionPattern;
        this.resultPartitionType = resultPartitionType;
        this.jobType = jobType;
        this.executionMode = executionMode;
        this.parallelism = parallelism;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public DistributionPattern getDistributionPattern() {
        return this.distributionPattern;
    }

    public ResultPartitionType getResultPartitionType() {
        return this.resultPartitionType;
    }

    public JobType getJobType() {
        return this.jobType;
    }

    public ExecutionMode getExecutionMode() {
        return this.executionMode;
    }
}

