/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import java.io.File;
import org.apache.flink.api.common.JobID;
import org.apache.flink.core.fs.EntropyInjectingFileSystem;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.local.LocalFileSystem;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.CheckpointedStateScope;
import org.apache.flink.runtime.state.filesystem.FileStateHandle;
import org.apache.flink.runtime.state.filesystem.FsCheckpointStorageAccess;
import org.apache.flink.runtime.state.filesystem.FsCheckpointStorageLocation;
import org.apache.flink.runtime.state.filesystem.FsCompletedCheckpointStorageLocation;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class FsStateBackendEntropyTest {
    static final String ENTROPY_MARKER = "__ENTROPY__";
    static final String RESOLVED_MARKER = "+RESOLVED+";
    @Rule
    public final TemporaryFolder tmp = new TemporaryFolder();

    @Test
    public void testEntropyInjection() throws Exception {
        FileStateHandle handle;
        int fileSizeThreshold = 1024;
        TestEntropyAwareFs fs = new TestEntropyAwareFs();
        Path checkpointDir = new Path(Path.fromLocalFile((File)this.tmp.newFolder()), "__ENTROPY__/checkpoints");
        String checkpointDirStr = checkpointDir.toString();
        FsCheckpointStorageAccess storage = new FsCheckpointStorageAccess((FileSystem)fs, checkpointDir, null, new JobID(), 1024, 4096);
        storage.initializeBaseLocations();
        FsCheckpointStorageLocation location = (FsCheckpointStorageLocation)storage.initializeLocationForCheckpoint(96562L);
        Assert.assertThat((Object)location.getCheckpointDirectory().toString(), (Matcher)Matchers.startsWith((String)checkpointDirStr));
        Assert.assertThat((Object)location.getSharedStateDirectory().toString(), (Matcher)Matchers.startsWith((String)checkpointDirStr));
        Assert.assertThat((Object)location.getTaskOwnedStateDirectory().toString(), (Matcher)Matchers.startsWith((String)checkpointDirStr));
        Assert.assertThat((Object)location.getMetadataFilePath().toString(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)ENTROPY_MARKER)));
        try (CheckpointStreamFactory.CheckpointStateOutputStream stream = storage.createTaskOwnedStateStream();){
            stream.write(new byte[1025], 0, 1025);
            handle = (FileStateHandle)stream.closeAndGetHandle();
            Assert.assertNotNull((Object)handle);
            Assert.assertThat((Object)handle.getFilePath().toString(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)ENTROPY_MARKER)));
            Assert.assertThat((Object)handle.getFilePath().toString(), (Matcher)Matchers.containsString((String)RESOLVED_MARKER));
        }
        stream = location.createCheckpointStateOutputStream(CheckpointedStateScope.EXCLUSIVE);
        var8_8 = null;
        try {
            stream.write(new byte[1025], 0, 1025);
            handle = (FileStateHandle)stream.closeAndGetHandle();
            Assert.assertNotNull((Object)handle);
            Assert.assertThat((Object)handle.getFilePath().toString(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)ENTROPY_MARKER)));
            Assert.assertThat((Object)handle.getFilePath().toString(), (Matcher)Matchers.containsString((String)RESOLVED_MARKER));
        }
        catch (Throwable handle2) {
            var8_8 = handle2;
            throw handle2;
        }
        finally {
            if (stream != null) {
                if (var8_8 != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable handle2) {
                        var8_8.addSuppressed(handle2);
                    }
                } else {
                    stream.close();
                }
            }
        }
        stream = location.createMetadataOutputStream();
        var8_8 = null;
        try {
            stream.flush();
            handle = (FsCompletedCheckpointStorageLocation)stream.closeAndFinalizeCheckpoint();
            Assert.assertNotNull((Object)handle);
            Assert.assertThat((Object)handle.getMetadataHandle().getFilePath().toString(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)ENTROPY_MARKER)));
            Assert.assertThat((Object)handle.getMetadataHandle().getFilePath().toString(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)RESOLVED_MARKER)));
            Assert.assertEquals((Object)handle.getMetadataHandle().getFilePath().getParent().toString(), (Object)handle.getExternalPointer());
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
        finally {
            if (stream != null) {
                if (var8_8 != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable) {
                        var8_8.addSuppressed(throwable);
                    }
                } else {
                    stream.close();
                }
            }
        }
    }

    static class TestEntropyAwareFs
    extends LocalFileSystem
    implements EntropyInjectingFileSystem {
        TestEntropyAwareFs() {
        }

        public String getEntropyInjectionKey() {
            return FsStateBackendEntropyTest.ENTROPY_MARKER;
        }

        public String generateEntropy() {
            return FsStateBackendEntropyTest.RESOLVED_MARKER;
        }
    }
}

