/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.apache.flink.runtime.broadcast.BroadcastVariableManager;
import org.apache.flink.runtime.execution.librarycache.LibraryCacheManager;
import org.apache.flink.runtime.execution.librarycache.TestingLibraryCacheManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.network.TaskEventDispatcher;
import org.apache.flink.runtime.query.KvStateRegistry;
import org.apache.flink.runtime.registration.RetryingRegistrationConfiguration;
import org.apache.flink.runtime.shuffle.ShuffleEnvironment;
import org.apache.flink.runtime.state.TaskExecutorLocalStateStoresManager;
import org.apache.flink.runtime.taskexecutor.DefaultJobLeaderService;
import org.apache.flink.runtime.taskexecutor.DefaultJobTable;
import org.apache.flink.runtime.taskexecutor.JobLeaderService;
import org.apache.flink.runtime.taskexecutor.JobTable;
import org.apache.flink.runtime.taskexecutor.KvStateService;
import org.apache.flink.runtime.taskexecutor.TaskManagerServices;
import org.apache.flink.runtime.taskexecutor.slot.TaskSlotTable;
import org.apache.flink.runtime.taskexecutor.slot.TestingTaskSlotTable;
import org.apache.flink.runtime.taskmanager.LocalUnresolvedTaskManagerLocation;
import org.apache.flink.runtime.taskmanager.Task;
import org.apache.flink.runtime.taskmanager.UnresolvedTaskManagerLocation;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.mockito.Mockito;

public class TaskManagerServicesBuilder {
    private UnresolvedTaskManagerLocation unresolvedTaskManagerLocation = new LocalUnresolvedTaskManagerLocation();
    private IOManager ioManager = (IOManager)Mockito.mock(IOManager.class);
    private ShuffleEnvironment<?, ?> shuffleEnvironment = (ShuffleEnvironment)Mockito.mock(ShuffleEnvironment.class);
    private KvStateService kvStateService = new KvStateService(new KvStateRegistry(), null, null);
    private BroadcastVariableManager broadcastVariableManager = new BroadcastVariableManager();
    private TaskSlotTable<Task> taskSlotTable;
    private JobTable jobTable;
    private JobLeaderService jobLeaderService;
    private TaskExecutorLocalStateStoresManager taskStateManager;
    private TaskEventDispatcher taskEventDispatcher = new TaskEventDispatcher();
    private ExecutorService ioExecutor;
    private LibraryCacheManager libraryCacheManager;
    private long managedMemorySize = 4096L;

    public TaskManagerServicesBuilder() {
        this.taskSlotTable = TestingTaskSlotTable.newBuilder().closeAsyncReturns(CompletableFuture.completedFuture(null)).build();
        this.jobTable = DefaultJobTable.create();
        this.jobLeaderService = new DefaultJobLeaderService(this.unresolvedTaskManagerLocation, RetryingRegistrationConfiguration.defaultConfiguration());
        this.taskStateManager = (TaskExecutorLocalStateStoresManager)Mockito.mock(TaskExecutorLocalStateStoresManager.class);
        this.ioExecutor = TestingUtils.defaultExecutor();
        this.libraryCacheManager = TestingLibraryCacheManager.newBuilder().build();
    }

    public TaskManagerServicesBuilder setUnresolvedTaskManagerLocation(UnresolvedTaskManagerLocation unresolvedTaskManagerLocation) {
        this.unresolvedTaskManagerLocation = unresolvedTaskManagerLocation;
        return this;
    }

    public TaskManagerServicesBuilder setIoManager(IOManager ioManager) {
        this.ioManager = ioManager;
        return this;
    }

    public TaskManagerServicesBuilder setShuffleEnvironment(ShuffleEnvironment<?, ?> shuffleEnvironment) {
        this.shuffleEnvironment = shuffleEnvironment;
        return this;
    }

    public TaskManagerServicesBuilder setKvStateService(KvStateService kvStateService) {
        this.kvStateService = kvStateService;
        return this;
    }

    public TaskManagerServicesBuilder setBroadcastVariableManager(BroadcastVariableManager broadcastVariableManager) {
        this.broadcastVariableManager = broadcastVariableManager;
        return this;
    }

    public TaskManagerServicesBuilder setTaskSlotTable(TaskSlotTable<Task> taskSlotTable) {
        this.taskSlotTable = taskSlotTable;
        return this;
    }

    public TaskManagerServicesBuilder setJobTable(JobTable jobTable) {
        this.jobTable = jobTable;
        return this;
    }

    public TaskManagerServicesBuilder setJobLeaderService(JobLeaderService jobLeaderService) {
        this.jobLeaderService = jobLeaderService;
        return this;
    }

    public TaskManagerServicesBuilder setTaskStateManager(TaskExecutorLocalStateStoresManager taskStateManager) {
        this.taskStateManager = taskStateManager;
        return this;
    }

    public TaskManagerServicesBuilder setIOExecutorService(ExecutorService ioExecutor) {
        this.ioExecutor = ioExecutor;
        return this;
    }

    public TaskManagerServicesBuilder setLibraryCacheManager(LibraryCacheManager libraryCacheManager) {
        this.libraryCacheManager = libraryCacheManager;
        return this;
    }

    public TaskManagerServicesBuilder setManagedMemorySize(long managedMemorySize) {
        this.managedMemorySize = managedMemorySize;
        return this;
    }

    public TaskManagerServices build() {
        return new TaskManagerServices(this.unresolvedTaskManagerLocation, this.managedMemorySize, this.ioManager, this.shuffleEnvironment, this.kvStateService, this.broadcastVariableManager, this.taskSlotTable, this.jobTable, this.jobLeaderService, this.taskStateManager, this.taskEventDispatcher, this.ioExecutor, this.libraryCacheManager);
    }
}

