/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.jobmaster.JobMasterGateway;
import org.apache.flink.runtime.taskexecutor.slot.TaskSlotTable;
import org.apache.flink.runtime.taskmanager.Task;
import org.apache.flink.runtime.taskmanager.TaskExecutionState;
import org.apache.flink.runtime.taskmanager.TaskManagerActions;

public class TestTaskManagerActions
implements TaskManagerActions {
    private final JobMasterGateway jobMasterGateway;
    private final TaskSlotTable<Task> taskSlotTable;
    private final TaskManagerActionListeners taskManagerActionListeners = new TaskManagerActionListeners();

    public TestTaskManagerActions(TaskSlotTable<Task> taskSlotTable, JobMasterGateway jobMasterGateway) {
        this.taskSlotTable = taskSlotTable;
        this.jobMasterGateway = jobMasterGateway;
    }

    public void addListener(ExecutionAttemptID eid, ExecutionState executionState, CompletableFuture<Void> future) {
        this.taskManagerActionListeners.addListener(eid, executionState, future);
    }

    public void notifyFatalError(String message, Throwable cause) {
    }

    public void failTask(ExecutionAttemptID executionAttemptID, Throwable cause) {
        if (this.taskSlotTable != null) {
            ((Task)this.taskSlotTable.getTask(executionAttemptID)).failExternally(cause);
        }
    }

    public void updateTaskExecutionState(TaskExecutionState taskExecutionState) {
        Optional listenerFuture = this.taskManagerActionListeners.getListenerFuture(taskExecutionState.getID(), taskExecutionState.getExecutionState());
        if (listenerFuture.isPresent()) {
            ((CompletableFuture)listenerFuture.get()).complete(null);
        }
        if (this.jobMasterGateway != null) {
            CompletableFuture futureAcknowledge = this.jobMasterGateway.updateTaskExecutionState(taskExecutionState);
            futureAcknowledge.whenComplete((ack, throwable) -> {
                if (throwable != null) {
                    this.failTask(taskExecutionState.getID(), (Throwable)throwable);
                }
            });
        }
    }

    private static class TaskManagerActionListeners {
        private final Map<ExecutionAttemptID, List<Tuple2<ExecutionState, CompletableFuture<Void>>>> expectExecutionStateAndFutures = new HashMap<ExecutionAttemptID, List<Tuple2<ExecutionState, CompletableFuture<Void>>>>();

        private TaskManagerActionListeners() {
        }

        private void addListener(ExecutionAttemptID eid, ExecutionState executionState, CompletableFuture<Void> future) {
            List expectExecutionStateAndFutureList = this.expectExecutionStateAndFutures.getOrDefault(eid, new ArrayList());
            expectExecutionStateAndFutureList.add(Tuple2.of((Object)executionState, future));
            this.expectExecutionStateAndFutures.put(eid, expectExecutionStateAndFutureList);
        }

        private Optional<CompletableFuture<Void>> getListenerFuture(ExecutionAttemptID eid, ExecutionState executionState) {
            List<Tuple2<ExecutionState, CompletableFuture<Void>>> expectStateAndFutureList = this.expectExecutionStateAndFutures.get(eid);
            if (this.expectExecutionStateAndFutures == null) {
                return Optional.empty();
            }
            for (Tuple2<ExecutionState, CompletableFuture<Void>> expectStateAndFuture : expectStateAndFutureList) {
                if (expectStateAndFuture.f0 != executionState) continue;
                return Optional.of(expectStateAndFuture.f1);
            }
            return Optional.empty();
        }
    }
}

