/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor.slot;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotID;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutorServiceAdapter;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.taskexecutor.SlotReport;
import org.apache.flink.runtime.taskexecutor.SlotStatus;
import org.apache.flink.runtime.taskexecutor.slot.SlotActions;
import org.apache.flink.runtime.taskexecutor.slot.SlotNotActiveException;
import org.apache.flink.runtime.taskexecutor.slot.SlotNotFoundException;
import org.apache.flink.runtime.taskexecutor.slot.TaskSlot;
import org.apache.flink.runtime.taskexecutor.slot.TaskSlotPayload;
import org.apache.flink.runtime.taskexecutor.slot.TaskSlotTable;
import org.apache.flink.runtime.taskexecutor.slot.TaskSlotTableImpl;
import org.apache.flink.runtime.taskexecutor.slot.TaskSlotUtils;
import org.apache.flink.runtime.taskexecutor.slot.TestingSlotActions;
import org.apache.flink.runtime.taskexecutor.slot.TestingSlotActionsBuilder;
import org.apache.flink.runtime.taskexecutor.slot.TestingTaskSlotPayload;
import org.apache.flink.shaded.guava18.com.google.common.collect.Sets;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.function.TriFunctionWithException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class TaskSlotTableImplTest
extends TestLogger {
    private static final Time SLOT_TIMEOUT = Time.seconds((long)100L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTryMarkSlotActive() throws Exception {
        TaskSlotTableImpl<TaskSlotPayload> taskSlotTable = TaskSlotTableImplTest.createTaskSlotTableAndStart(3);
        try {
            JobID jobId1 = new JobID();
            AllocationID allocationId1 = new AllocationID();
            taskSlotTable.allocateSlot(0, jobId1, allocationId1, SLOT_TIMEOUT);
            AllocationID allocationId2 = new AllocationID();
            taskSlotTable.allocateSlot(1, jobId1, allocationId2, SLOT_TIMEOUT);
            AllocationID allocationId3 = new AllocationID();
            JobID jobId2 = new JobID();
            taskSlotTable.allocateSlot(2, jobId2, allocationId3, SLOT_TIMEOUT);
            taskSlotTable.markSlotActive(allocationId1);
            Assert.assertThat((Object)taskSlotTable.isAllocated(0, jobId1, allocationId1), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)taskSlotTable.isAllocated(1, jobId1, allocationId2), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)taskSlotTable.isAllocated(2, jobId2, allocationId3), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)taskSlotTable.getActiveTaskSlotAllocationIdsPerJob(jobId1), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Sets.newHashSet((Object[])new AllocationID[]{allocationId1}))));
            Assert.assertThat((Object)taskSlotTable.tryMarkSlotActive(jobId1, allocationId1), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)taskSlotTable.tryMarkSlotActive(jobId1, allocationId2), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)taskSlotTable.tryMarkSlotActive(jobId1, allocationId3), (Matcher)Matchers.is((Object)false));
            Assert.assertThat((Object)taskSlotTable.getActiveTaskSlotAllocationIdsPerJob(jobId1), (Matcher)Matchers.is((Matcher)Matchers.equalTo(new HashSet<AllocationID>(Arrays.asList(allocationId2, allocationId1)))));
        }
        finally {
            taskSlotTable.close();
            Assert.assertThat((Object)taskSlotTable.isClosed(), (Matcher)Matchers.is((Object)true));
        }
    }

    @Test
    public void testRetrievingAllActiveSlots() throws Exception {
        try (TaskSlotTableImpl<TaskSlotPayload> taskSlotTable = TaskSlotTableImplTest.createTaskSlotTableAndStart(3);){
            JobID jobId1 = new JobID();
            AllocationID allocationId1 = new AllocationID();
            taskSlotTable.allocateSlot(0, jobId1, allocationId1, SLOT_TIMEOUT);
            AllocationID allocationId2 = new AllocationID();
            taskSlotTable.allocateSlot(1, jobId1, allocationId2, SLOT_TIMEOUT);
            AllocationID allocationId3 = new AllocationID();
            JobID jobId2 = new JobID();
            taskSlotTable.allocateSlot(2, jobId2, allocationId3, SLOT_TIMEOUT);
            taskSlotTable.markSlotActive(allocationId1);
            taskSlotTable.markSlotActive(allocationId3);
            Assert.assertThat((Object)taskSlotTable.getActiveTaskSlotAllocationIds(), (Matcher)Matchers.is((Object)Sets.newHashSet((Object[])new AllocationID[]{allocationId1, allocationId3})));
        }
    }

    @Test
    public void testInconsistentStaticSlotAllocation() throws Exception {
        try (TaskSlotTableImpl<TaskSlotPayload> taskSlotTable = TaskSlotTableImplTest.createTaskSlotTableAndStart(2);){
            JobID jobId = new JobID();
            AllocationID allocationId1 = new AllocationID();
            AllocationID allocationId2 = new AllocationID();
            Assert.assertThat((Object)taskSlotTable.allocateSlot(0, jobId, allocationId1, SLOT_TIMEOUT), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)taskSlotTable.allocateSlot(1, jobId, allocationId1, SLOT_TIMEOUT), (Matcher)Matchers.is((Object)false));
            Assert.assertThat((Object)taskSlotTable.allocateSlot(0, jobId, allocationId2, SLOT_TIMEOUT), (Matcher)Matchers.is((Object)false));
            Assert.assertThat((Object)taskSlotTable.isAllocated(0, jobId, allocationId1), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)taskSlotTable.isSlotFree(1), (Matcher)Matchers.is((Object)true));
            Iterator allocatedSlots = taskSlotTable.getAllocatedSlots(jobId);
            Assert.assertThat((Object)((TaskSlot)allocatedSlots.next()).getIndex(), (Matcher)Matchers.is((Object)0));
            Assert.assertThat((Object)allocatedSlots.hasNext(), (Matcher)Matchers.is((Object)false));
        }
    }

    @Test
    public void testInconsistentDynamicSlotAllocation() throws Exception {
        try (TaskSlotTableImpl<TaskSlotPayload> taskSlotTable = TaskSlotTableImplTest.createTaskSlotTableAndStart(1);){
            JobID jobId1 = new JobID();
            JobID jobId2 = new JobID();
            AllocationID allocationId = new AllocationID();
            Assert.assertThat((Object)taskSlotTable.allocateSlot(-1, jobId1, allocationId, SLOT_TIMEOUT), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)taskSlotTable.allocateSlot(-1, jobId2, allocationId, SLOT_TIMEOUT), (Matcher)Matchers.is((Object)false));
            Assert.assertThat((Object)taskSlotTable.isAllocated(1, jobId1, allocationId), (Matcher)Matchers.is((Object)true));
            Iterator allocatedSlots = taskSlotTable.getAllocatedSlots(jobId1);
            Assert.assertThat((Object)((TaskSlot)allocatedSlots.next()).getAllocationId(), (Matcher)Matchers.is((Object)allocationId));
            Assert.assertThat((Object)allocatedSlots.hasNext(), (Matcher)Matchers.is((Object)false));
        }
    }

    @Test
    public void testDuplicateStaticSlotAllocation() throws Exception {
        try (TaskSlotTableImpl<TaskSlotPayload> taskSlotTable = TaskSlotTableImplTest.createTaskSlotTableAndStart(2);){
            JobID jobId = new JobID();
            AllocationID allocationId = new AllocationID();
            Assert.assertThat((Object)taskSlotTable.allocateSlot(0, jobId, allocationId, ResourceProfile.UNKNOWN, SLOT_TIMEOUT), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)taskSlotTable.allocateSlot(0, jobId, allocationId, ResourceProfile.UNKNOWN, SLOT_TIMEOUT), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)taskSlotTable.isAllocated(0, jobId, allocationId), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)taskSlotTable.isSlotFree(1), (Matcher)Matchers.is((Object)true));
            Iterator allocatedSlots = taskSlotTable.getAllocatedSlots(jobId);
            Assert.assertThat((Object)((TaskSlot)allocatedSlots.next()).getIndex(), (Matcher)Matchers.is((Object)0));
            Assert.assertThat((Object)allocatedSlots.hasNext(), (Matcher)Matchers.is((Object)false));
        }
    }

    @Test
    public void testDuplicateDynamicSlotAllocation() throws Exception {
        try (TaskSlotTableImpl<TaskSlotPayload> taskSlotTable = TaskSlotTableImplTest.createTaskSlotTableAndStart(1);){
            JobID jobId = new JobID();
            AllocationID allocationId = new AllocationID();
            Assert.assertThat((Object)taskSlotTable.allocateSlot(-1, jobId, allocationId, SLOT_TIMEOUT), (Matcher)Matchers.is((Object)true));
            Iterator allocatedSlots = taskSlotTable.getAllocatedSlots(jobId);
            TaskSlot taskSlot1 = (TaskSlot)allocatedSlots.next();
            Assert.assertThat((Object)taskSlotTable.allocateSlot(-1, jobId, allocationId, SLOT_TIMEOUT), (Matcher)Matchers.is((Object)true));
            allocatedSlots = taskSlotTable.getAllocatedSlots(jobId);
            TaskSlot taskSlot2 = (TaskSlot)allocatedSlots.next();
            Assert.assertThat((Object)taskSlotTable.isAllocated(1, jobId, allocationId), (Matcher)Matchers.is((Object)true));
            Assert.assertEquals((Object)taskSlot1, (Object)taskSlot2);
            Assert.assertThat((Object)allocatedSlots.hasNext(), (Matcher)Matchers.is((Object)false));
        }
    }

    @Test
    public void testFreeSlot() throws Exception {
        try (TaskSlotTableImpl<TaskSlotPayload> taskSlotTable = TaskSlotTableImplTest.createTaskSlotTableAndStart(2);){
            JobID jobId = new JobID();
            AllocationID allocationId1 = new AllocationID();
            AllocationID allocationId2 = new AllocationID();
            Assert.assertThat((Object)taskSlotTable.allocateSlot(0, jobId, allocationId1, SLOT_TIMEOUT), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)taskSlotTable.allocateSlot(1, jobId, allocationId2, SLOT_TIMEOUT), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)taskSlotTable.freeSlot(allocationId2), (Matcher)Matchers.is((Object)1));
            Iterator allocatedSlots = taskSlotTable.getAllocatedSlots(jobId);
            Assert.assertThat((Object)((TaskSlot)allocatedSlots.next()).getIndex(), (Matcher)Matchers.is((Object)0));
            Assert.assertThat((Object)allocatedSlots.hasNext(), (Matcher)Matchers.is((Object)false));
            Assert.assertThat((Object)taskSlotTable.isAllocated(1, jobId, allocationId1), (Matcher)Matchers.is((Object)false));
            Assert.assertThat((Object)taskSlotTable.isAllocated(1, jobId, allocationId2), (Matcher)Matchers.is((Object)false));
            Assert.assertThat((Object)taskSlotTable.isSlotFree(1), (Matcher)Matchers.is((Object)true));
        }
    }

    @Test
    public void testSlotAllocationWithDynamicSlotId() throws Exception {
        try (TaskSlotTableImpl<TaskSlotPayload> taskSlotTable = TaskSlotTableImplTest.createTaskSlotTableAndStart(2);){
            JobID jobId = new JobID();
            AllocationID allocationId = new AllocationID();
            Assert.assertThat((Object)taskSlotTable.allocateSlot(-1, jobId, allocationId, SLOT_TIMEOUT), (Matcher)Matchers.is((Object)true));
            Iterator allocatedSlots = taskSlotTable.getAllocatedSlots(jobId);
            Assert.assertThat((Object)((TaskSlot)allocatedSlots.next()).getIndex(), (Matcher)Matchers.is((Object)2));
            Assert.assertThat((Object)allocatedSlots.hasNext(), (Matcher)Matchers.is((Object)false));
            Assert.assertThat((Object)taskSlotTable.isAllocated(2, jobId, allocationId), (Matcher)Matchers.is((Object)true));
        }
    }

    @Test
    public void testSlotAllocationWithConcreteResourceProfile() throws Exception {
        try (TaskSlotTableImpl<TaskSlotPayload> taskSlotTable = TaskSlotTableImplTest.createTaskSlotTableAndStart(2);){
            JobID jobId = new JobID();
            AllocationID allocationId = new AllocationID();
            ResourceProfile resourceProfile = TaskSlotUtils.DEFAULT_RESOURCE_PROFILE.merge(ResourceProfile.newBuilder().setCpuCores(0.1).build());
            Assert.assertThat((Object)taskSlotTable.allocateSlot(-1, jobId, allocationId, resourceProfile, SLOT_TIMEOUT), (Matcher)Matchers.is((Object)true));
            Iterator allocatedSlots = taskSlotTable.getAllocatedSlots(jobId);
            TaskSlot allocatedSlot = (TaskSlot)allocatedSlots.next();
            Assert.assertThat((Object)allocatedSlot.getIndex(), (Matcher)Matchers.is((Object)2));
            Assert.assertThat((Object)allocatedSlot.getResourceProfile(), (Matcher)Matchers.is((Object)resourceProfile));
            Assert.assertThat((Object)allocatedSlots.hasNext(), (Matcher)Matchers.is((Object)false));
        }
    }

    @Test
    public void testSlotAllocationWithUnknownResourceProfile() throws Exception {
        try (TaskSlotTableImpl<TaskSlotPayload> taskSlotTable = TaskSlotTableImplTest.createTaskSlotTableAndStart(2);){
            JobID jobId = new JobID();
            AllocationID allocationId = new AllocationID();
            Assert.assertThat((Object)taskSlotTable.allocateSlot(-1, jobId, allocationId, ResourceProfile.UNKNOWN, SLOT_TIMEOUT), (Matcher)Matchers.is((Object)true));
            Iterator allocatedSlots = taskSlotTable.getAllocatedSlots(jobId);
            TaskSlot allocatedSlot = (TaskSlot)allocatedSlots.next();
            Assert.assertThat((Object)allocatedSlot.getIndex(), (Matcher)Matchers.is((Object)2));
            Assert.assertThat((Object)allocatedSlot.getResourceProfile(), (Matcher)Matchers.is((Object)TaskSlotUtils.DEFAULT_RESOURCE_PROFILE));
            Assert.assertThat((Object)allocatedSlots.hasNext(), (Matcher)Matchers.is((Object)false));
        }
    }

    @Test
    public void testSlotAllocationWithResourceProfileFailure() throws Exception {
        try (TaskSlotTableImpl<TaskSlotPayload> taskSlotTable = TaskSlotTableImplTest.createTaskSlotTableAndStart(2);){
            JobID jobId = new JobID();
            AllocationID allocationId = new AllocationID();
            ResourceProfile resourceProfile = TaskSlotUtils.DEFAULT_RESOURCE_PROFILE;
            resourceProfile = resourceProfile.merge(resourceProfile).merge(resourceProfile);
            Assert.assertThat((Object)taskSlotTable.allocateSlot(-1, jobId, allocationId, resourceProfile, SLOT_TIMEOUT), (Matcher)Matchers.is((Object)false));
            Iterator allocatedSlots = taskSlotTable.getAllocatedSlots(jobId);
            Assert.assertThat((Object)allocatedSlots.hasNext(), (Matcher)Matchers.is((Object)false));
        }
    }

    @Test
    public void testGenerateSlotReport() throws Exception {
        try (TaskSlotTableImpl<TaskSlotPayload> taskSlotTable = TaskSlotTableImplTest.createTaskSlotTableAndStart(3);){
            JobID jobId = new JobID();
            AllocationID allocationId1 = new AllocationID();
            AllocationID allocationId2 = new AllocationID();
            AllocationID allocationId3 = new AllocationID();
            Assert.assertThat((Object)taskSlotTable.allocateSlot(0, jobId, allocationId1, SLOT_TIMEOUT), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)taskSlotTable.allocateSlot(-1, jobId, allocationId2, SLOT_TIMEOUT), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)taskSlotTable.allocateSlot(-1, jobId, allocationId3, SLOT_TIMEOUT), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)taskSlotTable.freeSlot(allocationId2), (Matcher)Matchers.is((Object)3));
            ResourceID resourceId = ResourceID.generate();
            SlotReport slotReport = taskSlotTable.createSlotReport(resourceId);
            ArrayList slotStatuses = new ArrayList();
            slotReport.iterator().forEachRemaining(slotStatuses::add);
            Assert.assertThat((Object)slotStatuses.size(), (Matcher)Matchers.is((Object)4));
            Assert.assertThat(slotStatuses, (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.is((Object)new SlotStatus(new SlotID(resourceId, 0), TaskSlotUtils.DEFAULT_RESOURCE_PROFILE, jobId, allocationId1)), Matchers.is((Object)new SlotStatus(new SlotID(resourceId, 1), TaskSlotUtils.DEFAULT_RESOURCE_PROFILE, null, null)), Matchers.is((Object)new SlotStatus(new SlotID(resourceId, 2), TaskSlotUtils.DEFAULT_RESOURCE_PROFILE, null, null)), Matchers.is((Object)new SlotStatus(new SlotID(resourceId, 4), TaskSlotUtils.DEFAULT_RESOURCE_PROFILE, jobId, allocationId3))}));
        }
    }

    @Test
    public void testAllocateSlot() throws Exception {
        JobID jobId = new JobID();
        AllocationID allocationId = new AllocationID();
        try (TaskSlotTable<TaskSlotPayload> taskSlotTable = TaskSlotTableImplTest.createTaskSlotTableWithAllocatedSlot(jobId, allocationId, new TestingSlotActionsBuilder().build());){
            Iterator allocatedSlots = taskSlotTable.getAllocatedSlots(jobId);
            TaskSlot nextSlot = (TaskSlot)allocatedSlots.next();
            Assert.assertThat((Object)nextSlot.getIndex(), (Matcher)Matchers.is((Object)0));
            Assert.assertThat((Object)nextSlot.getAllocationId(), (Matcher)Matchers.is((Object)allocationId));
            Assert.assertThat((Object)nextSlot.getJobId(), (Matcher)Matchers.is((Object)jobId));
            Assert.assertThat((Object)allocatedSlots.hasNext(), (Matcher)Matchers.is((Object)false));
        }
    }

    @Test
    public void testAddTask() throws Exception {
        JobID jobId = new JobID();
        ExecutionAttemptID executionAttemptId = new ExecutionAttemptID();
        AllocationID allocationId = new AllocationID();
        TestingTaskSlotPayload task = new TestingTaskSlotPayload(jobId, executionAttemptId, allocationId).terminate();
        try (TaskSlotTable<TaskSlotPayload> taskSlotTable = TaskSlotTableImplTest.createTaskSlotTableWithStartedTask(task);){
            Iterator tasks = taskSlotTable.getTasks(jobId);
            TaskSlotPayload nextTask = (TaskSlotPayload)tasks.next();
            Assert.assertThat((Object)nextTask.getExecutionId(), (Matcher)Matchers.is((Object)executionAttemptId));
            Assert.assertThat((Object)nextTask.getAllocationId(), (Matcher)Matchers.is((Object)allocationId));
            Assert.assertThat((Object)tasks.hasNext(), (Matcher)Matchers.is((Object)false));
        }
    }

    @Test(timeout=10000L)
    public void testRemoveTaskCallsFreeSlotAction() throws Exception {
        JobID jobId = new JobID();
        ExecutionAttemptID executionAttemptId = new ExecutionAttemptID();
        AllocationID allocationId = new AllocationID();
        CompletableFuture freeSlotFuture = new CompletableFuture();
        TestingSlotActions slotActions = new TestingSlotActions(freeSlotFuture::complete, (aid, uid) -> {});
        TestingTaskSlotPayload task = new TestingTaskSlotPayload(jobId, executionAttemptId, allocationId).terminate();
        try (TaskSlotTable<TaskSlotPayload> taskSlotTable = TaskSlotTableImplTest.createTaskSlotTableWithStartedTask(task, slotActions);){
            taskSlotTable.freeSlot(allocationId);
            taskSlotTable.removeTask(executionAttemptId);
            Assert.assertThat(freeSlotFuture.get(), (Matcher)Matchers.is((Object)allocationId));
        }
    }

    @Test(timeout=10000L)
    public void testFreeSlotInterruptsSubmittedTask() throws Exception {
        TestingTaskSlotPayload task = new TestingTaskSlotPayload();
        try (TaskSlotTable<TaskSlotPayload> taskSlotTable = TaskSlotTableImplTest.createTaskSlotTableWithStartedTask(task);){
            Assert.assertThat((Object)taskSlotTable.freeSlot(task.getAllocationId()), (Matcher)Matchers.is((Object)-1));
            task.waitForFailure();
            task.terminate();
        }
    }

    @Test(timeout=10000L)
    public void testTableIsClosedOnlyWhenAllTasksTerminated() throws Exception {
        TestingTaskSlotPayload task = new TestingTaskSlotPayload();
        TaskSlotTable<TaskSlotPayload> taskSlotTable = TaskSlotTableImplTest.createTaskSlotTableWithStartedTask(task);
        Assert.assertThat((Object)taskSlotTable.freeSlot(task.getAllocationId()), (Matcher)Matchers.is((Object)-1));
        CompletableFuture closingFuture = taskSlotTable.closeAsync();
        Assert.assertThat((Object)closingFuture.isDone(), (Matcher)Matchers.is((Object)false));
        task.terminate();
        closingFuture.get();
    }

    @Test
    public void testAllocatedSlotTimeout() throws Exception {
        CompletableFuture timeoutFuture = new CompletableFuture();
        TestingSlotActions testingSlotActions = new TestingSlotActionsBuilder().setTimeoutSlotConsumer((allocationID, uuid) -> timeoutFuture.complete(allocationID)).build();
        try (TaskSlotTableImpl<TaskSlotPayload> taskSlotTable = TaskSlotTableImplTest.createTaskSlotTableAndStart(1, testingSlotActions);){
            AllocationID allocationId = new AllocationID();
            Assert.assertThat((Object)taskSlotTable.allocateSlot(0, new JobID(), allocationId, Time.milliseconds((long)1L)), (Matcher)Matchers.is((Object)true));
            Assert.assertThat(timeoutFuture.join(), (Matcher)Matchers.is((Object)allocationId));
        }
    }

    @Test
    public void testMarkSlotActiveDeactivatesSlotTimeout() throws Exception {
        this.runDeactivateSlotTimeoutTest((TriFunctionWithException<TaskSlotTable<TaskSlotPayload>, JobID, AllocationID, Boolean, SlotNotFoundException>)((TriFunctionWithException)(taskSlotTable, jobId, allocationId) -> taskSlotTable.markSlotActive(allocationId)));
    }

    @Test
    public void testTryMarkSlotActiveDeactivatesSlotTimeout() throws Exception {
        this.runDeactivateSlotTimeoutTest((TriFunctionWithException<TaskSlotTable<TaskSlotPayload>, JobID, AllocationID, Boolean, SlotNotFoundException>)((TriFunctionWithException)TaskSlotTable::tryMarkSlotActive));
    }

    private void runDeactivateSlotTimeoutTest(TriFunctionWithException<TaskSlotTable<TaskSlotPayload>, JobID, AllocationID, Boolean, SlotNotFoundException> taskSlotTableAction) throws Exception {
        CompletableFuture timeoutFuture = new CompletableFuture();
        TestingSlotActions testingSlotActions = new TestingSlotActionsBuilder().setTimeoutSlotConsumer((allocationID, uuid) -> timeoutFuture.complete(allocationID)).build();
        try (TaskSlotTableImpl<TaskSlotPayload> taskSlotTable = TaskSlotTableImplTest.createTaskSlotTableAndStart(1, testingSlotActions);){
            AllocationID allocationId = new AllocationID();
            long timeout = 50L;
            JobID jobId = new JobID();
            Assert.assertThat((Object)taskSlotTable.allocateSlot(0, jobId, allocationId, Time.milliseconds((long)50L)), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)taskSlotTableAction.apply(taskSlotTable, (Object)jobId, (Object)allocationId), (Matcher)Matchers.is((Object)true));
            try {
                timeoutFuture.get(50L, TimeUnit.MILLISECONDS);
                Assert.fail((String)"The slot timeout should have been deactivated.");
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
        }
    }

    private static TaskSlotTable<TaskSlotPayload> createTaskSlotTableWithStartedTask(TaskSlotPayload task) throws SlotNotFoundException, SlotNotActiveException {
        return TaskSlotTableImplTest.createTaskSlotTableWithStartedTask(task, new TestingSlotActionsBuilder().build());
    }

    private static TaskSlotTable<TaskSlotPayload> createTaskSlotTableWithStartedTask(TaskSlotPayload task, SlotActions slotActions) throws SlotNotFoundException, SlotNotActiveException {
        TaskSlotTable<TaskSlotPayload> taskSlotTable = TaskSlotTableImplTest.createTaskSlotTableWithAllocatedSlot(task.getJobID(), task.getAllocationId(), slotActions);
        taskSlotTable.markSlotActive(task.getAllocationId());
        taskSlotTable.addTask(task);
        return taskSlotTable;
    }

    private static TaskSlotTable<TaskSlotPayload> createTaskSlotTableWithAllocatedSlot(JobID jobId, AllocationID allocationId, SlotActions slotActions) {
        TaskSlotTableImpl<TaskSlotPayload> taskSlotTable = TaskSlotTableImplTest.createTaskSlotTableAndStart(1, slotActions);
        Assert.assertThat((Object)taskSlotTable.allocateSlot(0, jobId, allocationId, SLOT_TIMEOUT), (Matcher)Matchers.is((Object)true));
        return taskSlotTable;
    }

    private static TaskSlotTableImpl<TaskSlotPayload> createTaskSlotTableAndStart(int numberOfSlots) {
        return TaskSlotTableImplTest.createTaskSlotTableAndStart(numberOfSlots, new TestingSlotActionsBuilder().build());
    }

    private static TaskSlotTableImpl<TaskSlotPayload> createTaskSlotTableAndStart(int numberOfSlots, SlotActions slotActions) {
        TaskSlotTableImpl taskSlotTable = TaskSlotUtils.createTaskSlotTable(numberOfSlots);
        taskSlotTable.start(slotActions, ComponentMainThreadExecutorServiceAdapter.forMainThread());
        return taskSlotTable;
    }
}

