/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.testingUtils;

import akka.actor.ActorRef;
import akka.actor.Kill$;
import akka.actor.ScalaActorRef;
import akka.actor.package$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.akka.AkkaUtils$;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.concurrent.ScheduledExecutorServiceAdapter;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;

public final class TestingUtils$ {
    public static final TestingUtils$ MODULE$;
    private ScheduledExecutorService sharedExecutorInstance;
    private final Config testConfig;
    private final Duration TESTING_DURATION;
    private final Duration TESTING_TIMEOUT;
    private final Time TIMEOUT;
    private final String DEFAULT_AKKA_ASK_TIMEOUT;

    static {
        new TestingUtils$();
    }

    private ScheduledExecutorService sharedExecutorInstance() {
        return this.sharedExecutorInstance;
    }

    private void sharedExecutorInstance_$eq(ScheduledExecutorService x$1) {
        this.sharedExecutorInstance = x$1;
    }

    public Config testConfig() {
        return this.testConfig;
    }

    public Duration TESTING_DURATION() {
        return this.TESTING_DURATION;
    }

    public Duration TESTING_TIMEOUT() {
        return this.TESTING_TIMEOUT;
    }

    public Time TIMEOUT() {
        return this.TIMEOUT;
    }

    public String DEFAULT_AKKA_ASK_TIMEOUT() {
        return this.DEFAULT_AKKA_ASK_TIMEOUT;
    }

    public String getDefaultTestingActorSystemConfigString() {
        String logLevel = AkkaUtils$.MODULE$.getLogLevel();
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"akka.daemonic = on\n      |akka.test.timefactor = 10\n      |akka.loggers = [\"akka.event.slf4j.Slf4jLogger\"]\n      |akka.loglevel = ", "\n      |akka.stdout-loglevel = OFF\n      |akka.jvm-exit-on-fatal-error = off\n      |akka.log-config-on-start = off\n      |akka.logger-startup-timeout = 30s\n    "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{logLevel})))).stripMargin();
    }

    public Config getDefaultTestingActorSystemConfig() {
        return this.testConfig();
    }

    public Time infiniteTime() {
        return Time.milliseconds((long)Integer.MAX_VALUE);
    }

    public ExecutionContextExecutor defaultExecutionContext() {
        return ExecutionContext$.MODULE$.fromExecutor((Executor)this.defaultExecutor());
    }

    public synchronized ScheduledExecutorService defaultExecutor() {
        if (this.sharedExecutorInstance() == null || this.sharedExecutorInstance().isShutdown()) {
            this.sharedExecutorInstance_$eq(Executors.newSingleThreadScheduledExecutor());
        }
        return this.sharedExecutorInstance();
    }

    public ScheduledExecutor defaultScheduledExecutor() {
        ScheduledExecutorService scheduledExecutorService = this.defaultExecutor();
        return new ScheduledExecutorServiceAdapter(scheduledExecutorService);
    }

    public ExecutionContextExecutor directExecutionContext() {
        return ExecutionContext$.MODULE$.fromExecutor(org.apache.flink.runtime.concurrent.Executors.directExecutor());
    }

    public TestingUtils.QueuedActionExecutionContext queuedActionExecutionContext() {
        return new TestingUtils.QueuedActionExecutionContext(new TestingUtils.ActionQueue());
    }

    public void stopActor(ActorRef actor) {
        if (actor != null) {
            ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(actor);
            Kill$ x$1 = Kill$.MODULE$;
            ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
            qual$1.$bang((Object)x$1, x$2);
        }
    }

    private TestingUtils$() {
        MODULE$ = this;
        this.testConfig = ConfigFactory.parseString((String)this.getDefaultTestingActorSystemConfigString());
        this.TESTING_DURATION = Duration.ofMinutes(2L);
        this.TESTING_TIMEOUT = Duration.ofMinutes(1L);
        this.TIMEOUT = Time.minutes((long)1L);
        this.DEFAULT_AKKA_ASK_TIMEOUT = "200 s";
    }
}

