/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.highavailability.HighAvailabilityServicesUtils;
import org.apache.flink.runtime.rpc.akka.AkkaRpcServiceUtils;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class AddressResolutionTest
extends TestLogger {
    private static final String ENDPOINT_NAME = "endpoint";
    private static final String NON_EXISTING_HOSTNAME = "foo.bar.com.invalid";
    private static final int PORT = 17234;

    @BeforeClass
    public static void check() {
        AddressResolutionTest.checkPreconditions();
    }

    private static void checkPreconditions() {
        boolean throwsException;
        try {
            InetAddress.getByName(NON_EXISTING_HOSTNAME);
            throwsException = false;
        }
        catch (UnknownHostException e) {
            throwsException = true;
        }
        Assume.assumeTrue((boolean)throwsException);
    }

    @Test
    public void testNoAddressResolution() throws UnknownHostException {
        AkkaRpcServiceUtils.getRpcUrl((String)NON_EXISTING_HOSTNAME, (int)17234, (String)ENDPOINT_NAME, (HighAvailabilityServicesUtils.AddressResolution)HighAvailabilityServicesUtils.AddressResolution.NO_ADDRESS_RESOLUTION, (Configuration)new Configuration());
    }

    @Test
    public void testTryAddressResolution() {
        try {
            AkkaRpcServiceUtils.getRpcUrl((String)NON_EXISTING_HOSTNAME, (int)17234, (String)ENDPOINT_NAME, (HighAvailabilityServicesUtils.AddressResolution)HighAvailabilityServicesUtils.AddressResolution.TRY_ADDRESS_RESOLUTION, (Configuration)new Configuration());
            Assert.fail((String)"This should fail with an UnknownHostException");
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }
}

