/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.DiscardingSink;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.functions.source.FromElementsFunction;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.api.functions.source.StatefulSequenceSource;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.streaming.api.operators.AbstractUdfStreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.apache.flink.util.SplittableIterator;
import org.junit.Assert;
import org.junit.Test;

public class StreamExecutionEnvironmentTest {
    @Test
    public void fromElementsWithBaseTypeTest1() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.fromElements(ParentClass.class, (Object[])new ParentClass[]{new SubClass(1, "Java"), new ParentClass(1, "hello")});
    }

    @Test(expected=IllegalArgumentException.class)
    public void fromElementsWithBaseTypeTest2() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.fromElements(new Object[]{SubClass.class, new SubClass(1, "Java"), new ParentClass(1, "hello")});
    }

    @Test
    public void testFromElementsDeducedType() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromElements((Object[])new String[]{"a", "b"});
        FromElementsFunction elementsFunction = (FromElementsFunction)StreamExecutionEnvironmentTest.getFunctionFromDataSource(source);
        Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO.createSerializer(env.getConfig()), (Object)elementsFunction.getSerializer());
    }

    @Test
    public void testFromElementsPostConstructionType() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromElements((Object[])new String[]{"a", "b"});
        GenericTypeInfo customType = new GenericTypeInfo(String.class);
        source.returns((TypeInformation)customType);
        FromElementsFunction elementsFunction = (FromElementsFunction)StreamExecutionEnvironmentTest.getFunctionFromDataSource(source);
        Assert.assertNotEquals((Object)BasicTypeInfo.STRING_TYPE_INFO.createSerializer(env.getConfig()), (Object)elementsFunction.getSerializer());
        Assert.assertEquals((Object)customType.createSerializer(env.getConfig()), (Object)elementsFunction.getSerializer());
    }

    @Test
    public void testFromCollectionParallelism() {
        try {
            BasicTypeInfo typeInfo = BasicTypeInfo.INT_TYPE_INFO;
            StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
            DataStreamSource dataStream1 = env.fromCollection(new DummySplittableIterator(), (TypeInformation)typeInfo);
            try {
                dataStream1.setParallelism(4);
                Assert.fail((String)"should throw an exception");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            dataStream1.addSink((SinkFunction)new DiscardingSink());
            DataStreamSource dataStream2 = env.fromParallelCollection(new DummySplittableIterator(), (TypeInformation)typeInfo).setParallelism(4);
            dataStream2.addSink((SinkFunction)new DiscardingSink());
            StreamGraph streamGraph = env.getStreamGraph();
            streamGraph.getStreamingPlanAsJSON();
            Assert.assertEquals((String)"Parallelism of collection source must be 1.", (long)1L, (long)streamGraph.getStreamNode(Integer.valueOf(dataStream1.getId())).getParallelism());
            Assert.assertEquals((String)"Parallelism of parallel collection source must be 4.", (long)4L, (long)streamGraph.getStreamNode(Integer.valueOf(dataStream2.getId())).getParallelism());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSources() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        SourceFunction<Integer> srcFun = new SourceFunction<Integer>(){
            private static final long serialVersionUID = 1L;

            public void run(SourceFunction.SourceContext<Integer> ctx) throws Exception {
            }

            public void cancel() {
            }
        };
        DataStreamSource src1 = env.addSource((SourceFunction)srcFun);
        src1.addSink((SinkFunction)new DiscardingSink());
        Assert.assertEquals((Object)srcFun, StreamExecutionEnvironmentTest.getFunctionFromDataSource(src1));
        List<Long> list = Arrays.asList(0L, 1L, 2L);
        DataStreamSource src2 = env.generateSequence(0L, 2L);
        Assert.assertTrue((boolean)(StreamExecutionEnvironmentTest.getFunctionFromDataSource(src2) instanceof StatefulSequenceSource));
        DataStreamSource src3 = env.fromElements((Object[])new Long[]{0L, 1L, 2L});
        Assert.assertTrue((boolean)(StreamExecutionEnvironmentTest.getFunctionFromDataSource(src3) instanceof FromElementsFunction));
        DataStreamSource src4 = env.fromCollection(list);
        Assert.assertTrue((boolean)(StreamExecutionEnvironmentTest.getFunctionFromDataSource(src4) instanceof FromElementsFunction));
    }

    @Test
    public void testFromSequence() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource src = env.fromSequence(0L, 2L);
        Assert.assertEquals((Object)BasicTypeInfo.LONG_TYPE_INFO, (Object)src.getType());
    }

    @Test
    public void testParallelismBounds() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        SourceFunction<Integer> srcFun = new SourceFunction<Integer>(){
            private static final long serialVersionUID = 1L;

            public void run(SourceFunction.SourceContext<Integer> ctx) throws Exception {
            }

            public void cancel() {
            }
        };
        SingleOutputStreamOperator operator = env.addSource((SourceFunction)srcFun).flatMap((FlatMapFunction)new FlatMapFunction<Integer, Object>(){
            private static final long serialVersionUID = 1L;

            public void flatMap(Integer value, Collector<Object> out) throws Exception {
            }
        });
        Assert.assertEquals((long)-1L, (long)operator.getTransformation().getMaxParallelism());
        try {
            operator.setParallelism(0);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        operator.setParallelism(1);
        Assert.assertEquals((long)1L, (long)operator.getParallelism());
        operator.setParallelism(32768);
        Assert.assertEquals((long)32768L, (long)operator.getParallelism());
        env.getStreamGraph("Flink Streaming Job", false).getJobGraph();
        Assert.assertEquals((long)-1L, (long)operator.getTransformation().getMaxParallelism());
        env.setMaxParallelism(42);
        env.getStreamGraph("Flink Streaming Job", false).getJobGraph();
        Assert.assertEquals((long)42L, (long)operator.getTransformation().getMaxParallelism());
        try {
            env.setMaxParallelism(0);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            env.setMaxParallelism(32769);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            operator.setMaxParallelism(0);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            operator.setMaxParallelism(32769);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        operator.setMaxParallelism(1);
        Assert.assertEquals((long)1L, (long)operator.getTransformation().getMaxParallelism());
        operator.setMaxParallelism(32768);
        Assert.assertEquals((long)32768L, (long)operator.getTransformation().getMaxParallelism());
        env.getStreamGraph("Flink Streaming Job", false).getJobGraph();
        Assert.assertEquals((long)32768L, (long)operator.getTransformation().getMaxParallelism());
    }

    @Test
    public void testGetStreamGraph() {
        try {
            BasicTypeInfo typeInfo = BasicTypeInfo.INT_TYPE_INFO;
            StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
            DataStreamSource dataStream1 = env.fromCollection(new DummySplittableIterator(), (TypeInformation)typeInfo);
            dataStream1.addSink((SinkFunction)new DiscardingSink());
            Assert.assertEquals((long)2L, (long)env.getStreamGraph().getStreamNodes().size());
            DataStreamSource dataStream2 = env.fromCollection(new DummySplittableIterator(), (TypeInformation)typeInfo);
            dataStream2.addSink((SinkFunction)new DiscardingSink());
            Assert.assertEquals((long)2L, (long)env.getStreamGraph().getStreamNodes().size());
            DataStreamSource dataStream3 = env.fromCollection(new DummySplittableIterator(), (TypeInformation)typeInfo);
            dataStream3.addSink((SinkFunction)new DiscardingSink());
            env.getExecutionPlan();
            DataStreamSource dataStream4 = env.fromCollection(new DummySplittableIterator(), (TypeInformation)typeInfo);
            dataStream4.addSink((SinkFunction)new DiscardingSink());
            Assert.assertEquals((long)4L, (long)env.getStreamGraph("TestJob").getStreamNodes().size());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDefaultJobName() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        this.testJobName("Flink Streaming Job", env);
    }

    @Test
    public void testUserDefinedJobName() {
        String jobName = "MyTestJob";
        Configuration config = new Configuration();
        config.set(PipelineOptions.NAME, (Object)jobName);
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment((Configuration)config);
        this.testJobName(jobName, env);
    }

    @Test
    public void testUserDefinedJobNameWithConfigure() {
        String jobName = "MyTestJob";
        Configuration config = new Configuration();
        config.set(PipelineOptions.NAME, (Object)jobName);
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.configure((ReadableConfig)config, this.getClass().getClassLoader());
        this.testJobName(jobName, env);
    }

    private void testJobName(String expectedJobName, StreamExecutionEnvironment env) {
        env.fromElements((Object[])new Integer[]{1, 2, 3}).print();
        StreamGraph streamGraph = env.getStreamGraph();
        Assert.assertEquals((Object)expectedJobName, (Object)streamGraph.getJobName());
    }

    @Test
    public void testAddSourceWithUserDefinedTypeInfo() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source1 = env.addSource((SourceFunction)new RowSourceFunction(), Types.ROW((TypeInformation[])new TypeInformation[]{Types.STRING}));
        Assert.assertEquals((Object)Types.ROW((TypeInformation[])new TypeInformation[]{Types.STRING}), (Object)source1.getType());
        DataStreamSource source2 = env.addSource((SourceFunction)new RowSourceFunction());
        Assert.assertEquals((Object)new GenericTypeInfo(Row.class), (Object)source2.getType());
    }

    private static StreamOperator<?> getOperatorFromDataStream(DataStream<?> dataStream) {
        StreamExecutionEnvironment env = dataStream.getExecutionEnvironment();
        StreamGraph streamGraph = env.getStreamGraph();
        return streamGraph.getStreamNode(Integer.valueOf(dataStream.getId())).getOperator();
    }

    private static <T> SourceFunction<T> getFunctionFromDataSource(DataStreamSource<T> dataStreamSource) {
        dataStreamSource.addSink((SinkFunction)new DiscardingSink());
        AbstractUdfStreamOperator operator = (AbstractUdfStreamOperator)StreamExecutionEnvironmentTest.getOperatorFromDataStream(dataStreamSource);
        return (SourceFunction)operator.getUserFunction();
    }

    private static class RowSourceFunction
    implements SourceFunction<Row>,
    ResultTypeQueryable<Row> {
        private static final long serialVersionUID = 5216362688122691404L;

        private RowSourceFunction() {
        }

        public TypeInformation<Row> getProducedType() {
            return TypeInformation.of(Row.class);
        }

        public void run(SourceFunction.SourceContext<Row> ctx) throws Exception {
        }

        public void cancel() {
        }
    }

    private static class SubClass
    extends ParentClass {
        public SubClass(int num, String string) {
            super(num, string);
        }
    }

    private static class ParentClass {
        int num;
        String string;

        public ParentClass(int num, String string) {
            this.num = num;
            this.string = string;
        }
    }

    private static class DummySplittableIterator<T>
    extends SplittableIterator<T> {
        private static final long serialVersionUID = 1312752876092210499L;

        private DummySplittableIterator() {
        }

        public Iterator<T>[] split(int numPartitions) {
            return new Iterator[0];
        }

        public int getMaximumNumberOfSplits() {
            return 0;
        }

        public boolean hasNext() {
            return false;
        }

        public T next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

