/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.io.Closeable;
import org.apache.flink.core.fs.CloseableRegistry;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.CheckpointedStateScope;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateCheckpointOutputStream;
import org.apache.flink.runtime.state.OperatorStateCheckpointOutputStream;
import org.apache.flink.runtime.state.StateSnapshotContextSynchronousImpl;
import org.apache.flink.runtime.state.memory.MemCheckpointStreamFactory;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;

public class StateSnapshotContextSynchronousImplTest
extends TestLogger {
    private StateSnapshotContextSynchronousImpl snapshotContext;

    @Before
    public void setUp() throws Exception {
        CloseableRegistry closableRegistry = new CloseableRegistry();
        MemCheckpointStreamFactory streamFactory = new MemCheckpointStreamFactory(1024);
        KeyGroupRange keyGroupRange = new KeyGroupRange(0, 2);
        this.snapshotContext = new StateSnapshotContextSynchronousImpl(42L, 4711L, (CheckpointStreamFactory)streamFactory, keyGroupRange, closableRegistry);
    }

    @Test
    public void testMetaData() {
        Assert.assertEquals((long)42L, (long)this.snapshotContext.getCheckpointId());
        Assert.assertEquals((long)4711L, (long)this.snapshotContext.getCheckpointTimestamp());
    }

    @Test
    public void testCreateRawKeyedStateOutput() throws Exception {
        KeyedStateCheckpointOutputStream stream = this.snapshotContext.getRawKeyedOperatorStateOutput();
        Assert.assertNotNull((Object)stream);
    }

    @Test
    public void testCreateRawOperatorStateOutput() throws Exception {
        OperatorStateCheckpointOutputStream stream = this.snapshotContext.getRawOperatorStateOutput();
        Assert.assertNotNull((Object)stream);
    }

    @Test
    public void testStreamClosingWhenClosing() throws Exception {
        long checkpointId = 42L;
        long checkpointTimestamp = 1L;
        CheckpointStreamFactory.CheckpointStateOutputStream outputStream1 = (CheckpointStreamFactory.CheckpointStateOutputStream)Mockito.mock(CheckpointStreamFactory.CheckpointStateOutputStream.class);
        CheckpointStreamFactory.CheckpointStateOutputStream outputStream2 = (CheckpointStreamFactory.CheckpointStateOutputStream)Mockito.mock(CheckpointStreamFactory.CheckpointStateOutputStream.class);
        CheckpointStreamFactory streamFactory = (CheckpointStreamFactory)Mockito.mock(CheckpointStreamFactory.class);
        PowerMockito.when((Object)streamFactory.createCheckpointStateOutputStream(CheckpointedStateScope.EXCLUSIVE)).thenReturn((Object)outputStream1, (Object[])new CheckpointStreamFactory.CheckpointStateOutputStream[]{outputStream2});
        InsightCloseableRegistry closableRegistry = new InsightCloseableRegistry();
        KeyGroupRange keyGroupRange = new KeyGroupRange(0, 2);
        StateSnapshotContextSynchronousImpl context = new StateSnapshotContextSynchronousImpl(checkpointId, checkpointTimestamp, streamFactory, keyGroupRange, (CloseableRegistry)closableRegistry);
        context.getRawKeyedOperatorStateOutput();
        context.getRawOperatorStateOutput();
        ((CheckpointStreamFactory)Mockito.verify((Object)streamFactory, (VerificationMode)Mockito.times((int)2))).createCheckpointStateOutputStream(CheckpointedStateScope.EXCLUSIVE);
        Assert.assertEquals((long)2L, (long)closableRegistry.size());
        Assert.assertTrue((boolean)closableRegistry.contains((Closeable)outputStream1));
        Assert.assertTrue((boolean)closableRegistry.contains((Closeable)outputStream2));
        context.getKeyedStateStreamFuture().run();
        context.getOperatorStateStreamFuture().run();
        ((CheckpointStreamFactory.CheckpointStateOutputStream)Mockito.verify((Object)outputStream1)).closeAndGetHandle();
        ((CheckpointStreamFactory.CheckpointStateOutputStream)Mockito.verify((Object)outputStream2)).closeAndGetHandle();
        Assert.assertEquals((long)0L, (long)closableRegistry.size());
    }

    @Test
    public void testStreamClosingExceptionally() throws Exception {
        long checkpointId = 42L;
        long checkpointTimestamp = 1L;
        CheckpointStreamFactory.CheckpointStateOutputStream outputStream1 = (CheckpointStreamFactory.CheckpointStateOutputStream)Mockito.mock(CheckpointStreamFactory.CheckpointStateOutputStream.class);
        CheckpointStreamFactory.CheckpointStateOutputStream outputStream2 = (CheckpointStreamFactory.CheckpointStateOutputStream)Mockito.mock(CheckpointStreamFactory.CheckpointStateOutputStream.class);
        CheckpointStreamFactory streamFactory = (CheckpointStreamFactory)Mockito.mock(CheckpointStreamFactory.class);
        PowerMockito.when((Object)streamFactory.createCheckpointStateOutputStream(CheckpointedStateScope.EXCLUSIVE)).thenReturn((Object)outputStream1, (Object[])new CheckpointStreamFactory.CheckpointStateOutputStream[]{outputStream2});
        InsightCloseableRegistry closableRegistry = new InsightCloseableRegistry();
        KeyGroupRange keyGroupRange = new KeyGroupRange(0, 2);
        StateSnapshotContextSynchronousImpl context = new StateSnapshotContextSynchronousImpl(checkpointId, checkpointTimestamp, streamFactory, keyGroupRange, (CloseableRegistry)closableRegistry);
        context.getRawKeyedOperatorStateOutput();
        context.getRawOperatorStateOutput();
        ((CheckpointStreamFactory)Mockito.verify((Object)streamFactory, (VerificationMode)Mockito.times((int)2))).createCheckpointStateOutputStream(CheckpointedStateScope.EXCLUSIVE);
        Assert.assertEquals((long)2L, (long)closableRegistry.size());
        Assert.assertTrue((boolean)closableRegistry.contains((Closeable)outputStream1));
        Assert.assertTrue((boolean)closableRegistry.contains((Closeable)outputStream2));
        context.closeExceptionally();
        ((CheckpointStreamFactory.CheckpointStateOutputStream)Mockito.verify((Object)outputStream1)).close();
        ((CheckpointStreamFactory.CheckpointStateOutputStream)Mockito.verify((Object)outputStream2)).close();
        Assert.assertEquals((long)0L, (long)closableRegistry.size());
    }

    static final class InsightCloseableRegistry
    extends CloseableRegistry {
        InsightCloseableRegistry() {
        }

        public int size() {
            return this.getNumberOfRegisteredCloseables();
        }

        public boolean contains(Closeable closeable) {
            return this.isCloseableRegistered(closeable);
        }
    }
}

