/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.transformations;

import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.operators.ResourceSpec;
import org.apache.flink.api.common.typeinfo.IntegerTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.sink.Sink;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.core.memory.ManagedMemoryUseCase;
import org.apache.flink.streaming.api.transformations.SinkTransformation;
import org.apache.flink.streaming.runtime.operators.sink.TestSink;
import org.junit.Test;

public class SinkTransformationTest {
    @Test(expected=UnsupportedOperationException.class)
    public void unSupportSetResource() {
        SinkTransformation<Integer, String, String, String> sinkTransformation = SinkTransformationTest.createSinkTransformation();
        sinkTransformation.setResources(ResourceSpec.newBuilder((double)1.0, (int)1).build(), ResourceSpec.newBuilder((double)2.0, (int)2).build());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void unSupportDeclareOperatorScopeManagedMemory() {
        SinkTransformation<Integer, String, String, String> sinkTransformation = SinkTransformationTest.createSinkTransformation();
        sinkTransformation.declareManagedMemoryUseCaseAtOperatorScope(ManagedMemoryUseCase.STATE_BACKEND, 1);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void unSupportDeclareSlotScopeManagedMemory() {
        SinkTransformation<Integer, String, String, String> sinkTransformation = SinkTransformationTest.createSinkTransformation();
        sinkTransformation.declareManagedMemoryUseCaseAtSlotScope(ManagedMemoryUseCase.STATE_BACKEND);
    }

    private static SinkTransformation<Integer, String, String, String> createSinkTransformation() {
        return new SinkTransformation(new TestTransformation("src", IntegerTypeInfo.INT_TYPE_INFO, 1), (Sink)TestSink.newBuilder().build(), "sink", 1);
    }

    private static class TestTransformation<T>
    extends Transformation<T> {
        public TestTransformation(String name, TypeInformation<T> outputType, int parallelism) {
            super(name, outputType, parallelism);
        }

        public List<Transformation<?>> getTransitivePredecessors() {
            return Collections.emptyList();
        }

        public List<Transformation<?>> getInputs() {
            return Collections.emptyList();
        }
    }
}

